/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.application.dao.SysApplicationCommonMapper;
import com.jxdinfo.hussar.application.dto.SysAppVisitAuthorizeDto;
import com.jxdinfo.hussar.application.dto.SysApplicationDto;
import com.jxdinfo.hussar.application.factory.HussarApplicationCallBackFactory;
import com.jxdinfo.hussar.application.model.SysAppClient;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeam;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeamMember;
import com.jxdinfo.hussar.application.model.SysAppOperationLog;
import com.jxdinfo.hussar.application.model.SysAppRecycle;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysAppClientService;
import com.jxdinfo.hussar.application.service.ISysAppDevelopTeamMemberService;
import com.jxdinfo.hussar.application.service.ISysAppDevelopTeamService;
import com.jxdinfo.hussar.application.service.ISysAppOperationLogService;
import com.jxdinfo.hussar.application.service.ISysAppRecycleService;
import com.jxdinfo.hussar.application.service.ISysAppVisitAuthorizationService;
import com.jxdinfo.hussar.application.service.ISysApplicationBoService;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.application.vo.SysAppGroupVo;
import com.jxdinfo.hussar.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.common.utils.TranslateUtil;
import com.jxdinfo.hussar.iam.client.service.IHussarIamClientModelService;
import com.jxdinfo.hussar.iam.client.vo.ClientVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.application.service.impl.sysApplicationBoServiceImpl")
public class SysApplicationBoServiceImpl
implements ISysApplicationBoService {
    @Autowired
    private ISysApplicationService sysApplicationService;
    @Autowired
    private ISysAppOperationLogService sysAppOperationLogService;
    @Autowired
    private ISysAppClientService sysAppClientService;
    @Resource
    private IHussarIamClientModelService iHussarIamClientModelService;
    @Resource
    private ISysAppRecycleService sysAppRecycleService;
    @Resource
    private SysApplicationCommonMapper sysApplicationCommonMapper;
    @Resource
    private IHussarBaseUserBoService userBoService;
    @Resource
    private ISysAppDevelopTeamService sysAppDevelopTeamService;
    @Resource
    private ISysAppDevelopTeamMemberService sysAppDevelopTeamMemberService;
    @Resource
    private ISysAppVisitAuthorizationService sysAppVisitAuthorizationService;

    public Boolean addApp(SysApplicationDto sysApplicationDto) {
        return this.sysApplicationService.addApp(sysApplicationDto);
    }

    public Boolean updateApp(SysApplicationDto sysApplicationDto) {
        return this.sysApplicationService.updateApp(sysApplicationDto);
    }

    public Boolean editApp(SysApplicationDto sysApplicationDto) {
        return this.sysApplicationService.updateById((Object)sysApplicationDto);
    }

    public Boolean saveAppOperation(Long appId) {
        return this.sysAppOperationLogService.saveAppOperation(appId, "2");
    }

    public ClientVo getAppClientSecret(Long appId) {
        SysAppClient appClient = (SysAppClient)this.sysAppClientService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppClient::getAppId, (Object)appId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        if (HussarUtils.isNotEmpty((Object)appClient)) {
            return (ClientVo)this.iHussarIamClientModelService.detail(appClient.getClientModelId()).getData();
        }
        return null;
    }

    public SysApplicationVo addApplication(SysApplicationDto sysApplicationDto) {
        return this.sysApplicationService.addApplication(sysApplicationDto);
    }

    public Boolean removeApplication(Long appId) {
        ClientVo client;
        boolean flag = false;
        SysApplication appInfo = (SysApplication)this.sysApplicationService.getById((Serializable)appId);
        if (HussarUtils.isEmpty((Object)appInfo)) {
            return flag;
        }
        SysAppRecycle sysAppRecycle = new SysAppRecycle();
        BeanUtils.copyProperties((Object)appInfo, (Object)sysAppRecycle);
        sysAppRecycle.setDeleteUser(Long.valueOf(BaseSecurityUtil.getUser() == null ? 0L : BaseSecurityUtil.getUser().getUserId()));
        sysAppRecycle.setCreateUser(Long.valueOf(BaseSecurityUtil.getUser() == null ? 0L : BaseSecurityUtil.getUser().getUserId()));
        sysAppRecycle.setDeleteTime(LocalDateTime.now());
        this.sysAppRecycleService.save((Object)sysAppRecycle);
        flag = this.sysApplicationService.removeById((Serializable)appId);
        SysAppClient appClient = (SysAppClient)this.sysAppClientService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysAppClient::getAppId, (Object)appId));
        if (HussarUtils.isNotEmpty((Object)appClient) && HussarUtils.isNotEmpty((Object)(client = (ClientVo)this.iHussarIamClientModelService.detail(appClient.getClientModelId()).getData()))) {
            this.iHussarIamClientModelService.updateClientStatus(client.getClientId(), "0");
        }
        this.sysAppOperationLogService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(SysAppOperationLog::getOperationType, (Object)"1")).eq(SysAppOperationLog::getAppId, (Object)appId));
        HussarApplicationCallBackFactory.deleteApp(appInfo);
        return flag;
    }

    public ApiResponse<SysApplicationVo> getAppDetailNoVerification(Long appId) {
        SysApplicationVo sysApplicationVo = this.sysApplicationCommonMapper.getAppDetail(appId);
        if (HussarUtils.isNotEmpty((Object)sysApplicationVo)) {
            ArrayList<SysApplicationVo> sysApplicationVoList = new ArrayList<SysApplicationVo>();
            sysApplicationVoList.add(sysApplicationVo);
            this.setUserInfo(sysApplicationVoList);
        }
        return ApiResponse.success((Object)sysApplicationVo);
    }

    private void setUserInfo(List<SysApplicationVo> appList) {
        if (HussarUtils.isNotEmpty(appList)) {
            List userIdList = appList.stream().map(HussarBaseEntity::getCreator).collect(Collectors.toList());
            Map userMap = this.userBoService.getUserInfo(userIdList);
            for (SysApplicationVo item : appList) {
                SysUsers sysUsers = (SysUsers)userMap.get(item.getCreator());
                if (!HussarUtils.isNotEmpty((Object)sysUsers)) continue;
                item.setCreateUserName(sysUsers.getUserName());
            }
        }
    }

    public Boolean checkAppAdministrator(Long appId) {
        SysAppDevelopTeam sysAppDevelopTeam = (SysAppDevelopTeam)this.sysAppDevelopTeamService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeam::getAppId, (Object)appId));
        if (HussarUtils.isEmpty((Object)sysAppDevelopTeam)) {
            return false;
        }
        Long userId = BaseSecurityUtil.getUser().getId();
        Long teamId = sysAppDevelopTeam.getId();
        SysAppDevelopTeamMember sysAppDevelopTeamMember = (SysAppDevelopTeamMember)this.sysAppDevelopTeamMemberService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeamMember::getTeamId, (Object)teamId)).eq(SysAppDevelopTeamMember::getUserId, (Object)userId));
        return HussarUtils.isNotEmpty((Object)sysAppDevelopTeamMember) && HussarUtils.equals((Object)sysAppDevelopTeamMember.getMemberType(), (Object)"1");
    }

    public Boolean addAuthorization(SysAppVisitAuthorizeDto appVisitAuthorizeDto) {
        return this.sysAppVisitAuthorizationService.addAuthorization(appVisitAuthorizeDto);
    }

    public List<SysApplicationVo> getAppList(String appName, List<Long> appIds) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("appName", SqlQueryUtil.transferSpecialChar((String)StringUtils.trimToEmpty((String)appName)));
        queryParams.put("appIds", appIds);
        List<SysApplicationVo> appList = this.sysApplicationCommonMapper.getAppList(queryParams);
        TranslateUtil.translateByJson(appList, SysApplication::getI18nKeys);
        return appList;
    }

    public List<SysApplicationVo> getAppListManage(Long appGroupId, String appName, List<Long> appIds, String appStatus) {
        List<SysApplicationVo> appListManage = this.sysApplicationCommonMapper.getAppListManage(appGroupId, appName, appIds, null, appStatus);
        TranslateUtil.translateByJson(appListManage, SysApplication::getI18nKeys);
        return appListManage;
    }

    public SysApplicationVo getAppDetailContainUserName(Long appId) {
        if (HussarUtils.isEmpty((Object)appId)) {
            return null;
        }
        return this.sysApplicationCommonMapper.getAppDetail(appId);
    }

    public SysApplicationVo getAppDetail(Long appId) {
        if (HussarUtils.isEmpty((Object)appId)) {
            return null;
        }
        return this.sysApplicationCommonMapper.getAppDetail(appId);
    }

    public SysApplicationVo getAppByName(String appName) {
        if (HussarUtils.isEmpty((Object)appName)) {
            return null;
        }
        return this.sysApplicationCommonMapper.getAppByName(appName);
    }

    public List<Long> selectAllAppList() {
        return this.sysApplicationCommonMapper.selectAllAppList();
    }

    public SysApplication selectById(Long appId) {
        return (SysApplication)this.sysApplicationCommonMapper.selectById(appId);
    }

    public List<SysApplication> list() {
        LambdaQueryWrapper sysApplicationLambdaQueryWrapper = new LambdaQueryWrapper();
        return this.sysApplicationCommonMapper.selectList((Wrapper)sysApplicationLambdaQueryWrapper);
    }

    public List<SysAppGroupVo> getManageAppList(Long appGroupId, String appName, List<String> appTypes) {
        return this.sysApplicationService.getManageAppList(appGroupId, appName, appTypes);
    }

    public List<SysApplication> getAppListByAppType(String appType) {
        LambdaQueryWrapper sysApplicationLambdaQueryWrapper = new LambdaQueryWrapper();
        sysApplicationLambdaQueryWrapper.eq(SysApplication::getAppType, (Object)appType);
        return this.sysApplicationService.list((Wrapper)sysApplicationLambdaQueryWrapper);
    }

    public Boolean deleteAppCascade(Long appId) {
        return this.sysApplicationService.deleteAppCascade(appId);
    }

    public SysApplicationVo getAppDetailByAppCode(String appCode) {
        SysApplicationVo sysApplicationVo = this.sysApplicationCommonMapper.getAppDetailByAppCode(appCode);
        if (HussarUtils.isNotEmpty((Object)sysApplicationVo)) {
            ArrayList<SysApplicationVo> sysApplicationVoList = new ArrayList<SysApplicationVo>();
            sysApplicationVoList.add(sysApplicationVo);
            this.setUserInfo(sysApplicationVoList);
        }
        return sysApplicationVo;
    }
}

