/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.factory;

import com.jxdinfo.hussar.application.model.SysAppRecycle;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.IHussarAppCallBackService;
import com.jxdinfo.hussar.application.service.IOutsideAppCallBackService;
import com.jxdinfo.hussar.application.util.NacosUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class HussarApplicationCallBackFactory
implements ApplicationContextAware {
    private static final Map<String, IHussarAppCallBackService> map = new HashMap<String, IHussarAppCallBackService>();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map beanMap = applicationContext.getBeansOfType(IHussarAppCallBackService.class);
        this.setBeansToMap(beanMap);
    }

    private void setBeansToMap(Map<String, IHussarAppCallBackService> beanMap) {
        for (IHussarAppCallBackService appCallBackService : beanMap.values()) {
            map.put(appCallBackService.getAppType(), appCallBackService);
        }
    }

    public static IHussarAppCallBackService getAppCallBackService(String appType) {
        IHussarAppCallBackService appCallBackService = map.get(appType);
        return ToolUtil.isEmpty((Object)appCallBackService) ? map.get("default") : appCallBackService;
    }

    private static IOutsideAppCallBackService getFeignService(String appType, String serviceName) {
        boolean isMicroservice = NacosUtil.isMicroService();
        if (!isMicroservice || !"1".equals(appType)) {
            return null;
        }
        String currentServiceName = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.application.name");
        if (HussarUtils.isBlank((CharSequence)serviceName) || serviceName.equalsIgnoreCase(currentServiceName)) {
            return null;
        }
        return (IOutsideAppCallBackService)SpringContextHolder.getBean(IOutsideAppCallBackService.class);
    }

    public static void addCallback(SysApplication app) {
        IOutsideAppCallBackService feignService = HussarApplicationCallBackFactory.getFeignService(app.getAppType(), app.getServiceName());
        if (feignService != null) {
            feignService.addApp(app);
        } else {
            HussarApplicationCallBackFactory.getAppCallBackService(app.getAppType()).addApp(app);
        }
    }

    public static void deleteApp(SysApplication app) {
        IOutsideAppCallBackService feignService = HussarApplicationCallBackFactory.getFeignService(app.getAppType(), app.getServiceName());
        if (feignService != null) {
            feignService.deleteApp(app);
        } else {
            HussarApplicationCallBackFactory.getAppCallBackService(app.getAppType()).deleteApp(app);
        }
    }

    public static void beforeDeleteApp(SysApplication app) {
        IOutsideAppCallBackService feignService = HussarApplicationCallBackFactory.getFeignService(app.getAppType(), app.getServiceName());
        if (feignService != null) {
            feignService.beforeDeleteApp(app);
        } else {
            HussarApplicationCallBackFactory.getAppCallBackService(app.getAppType()).beforeDeleteApp(app);
        }
    }

    public static void updateApp(SysApplication app) {
        IOutsideAppCallBackService feignService = HussarApplicationCallBackFactory.getFeignService(app.getAppType(), app.getServiceName());
        if (feignService != null) {
            feignService.updateApp(app);
        } else {
            HussarApplicationCallBackFactory.getAppCallBackService(app.getAppType()).updateApp(app);
        }
    }

    public static void deleteRecycleApp(SysAppRecycle appRecycle) {
        IOutsideAppCallBackService feignService = HussarApplicationCallBackFactory.getFeignService(appRecycle.getAppType(), appRecycle.getServiceName());
        if (feignService != null) {
            feignService.deleteRecycleApp(appRecycle);
        } else {
            HussarApplicationCallBackFactory.getAppCallBackService(appRecycle.getAppType()).deleteRecycleApp(appRecycle);
        }
    }

    public static void revertRecycleApp(SysAppRecycle appRecycle) {
        IOutsideAppCallBackService feignService = HussarApplicationCallBackFactory.getFeignService(appRecycle.getAppType(), appRecycle.getServiceName());
        if (feignService != null) {
            feignService.revertRecycleApp(appRecycle);
        } else {
            HussarApplicationCallBackFactory.getAppCallBackService(appRecycle.getAppType()).revertRecycleApp(appRecycle);
        }
    }

    public static void beforeDeleteRecycleApp(SysAppRecycle appRecycle) {
        IOutsideAppCallBackService feignService = HussarApplicationCallBackFactory.getFeignService(appRecycle.getAppType(), appRecycle.getServiceName());
        if (feignService != null) {
            feignService.beforeDeleteRecycleApp(appRecycle);
        } else {
            HussarApplicationCallBackFactory.getAppCallBackService(appRecycle.getAppType()).beforeDeleteRecycleApp(appRecycle);
        }
    }
}

