/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.application.dao.SysAppVisitAuthorizationMapper;
import com.jxdinfo.hussar.application.dao.SysApplicationCommonMapper;
import com.jxdinfo.hussar.application.dto.SysAppAuthorizationDto;
import com.jxdinfo.hussar.application.dto.SysAppVisitAuthorizeDto;
import com.jxdinfo.hussar.application.factory.HussarAppVisitAuthCallBackFactory;
import com.jxdinfo.hussar.application.model.SysAppVisitAuthorization;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysAppOperationLogService;
import com.jxdinfo.hussar.application.service.ISysAppVisitAuthorizationService;
import com.jxdinfo.hussar.application.vo.SysAppRoleVo;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationBoService;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.authorization.post.service.IHussarBasePostBoService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.application.service.impl.SysAppVisitAuthorizationServiceImpl")
public class SysAppVisitAuthorizationServiceImpl
extends HussarServiceImpl<SysAppVisitAuthorizationMapper, SysAppVisitAuthorization>
implements ISysAppVisitAuthorizationService {
    @Resource
    private ISysAppOperationLogService sysAppOperationLogService;
    @Resource
    private SysAppVisitAuthorizationMapper sysAppVisitAuthorizationMapper;
    @Resource
    private ISysRolesExternalService sysRolesService;
    @Resource
    private IHussarBasePostBoService postBoService;
    @Resource
    private IHussarBaseOrganizationBoService organizationBoService;
    @Resource
    private IHussarBaseUserBoService userBoService;
    @Resource
    private SysApplicationCommonMapper sysApplicationCommonMapper;
    private static final String ORGAN_TYPE = "1";
    private static final String ROLE_TYPE = "2";
    private static final String POST_TYPE = "3";
    private static final String USERS_TYPE = "4";

    @HussarTransactional
    public Boolean addAuthorization(SysAppVisitAuthorizeDto appAuthorizeDto) {
        List sysAppAuthorizationDto = appAuthorizeDto.getAppAuthorList();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysAppVisitAuthorization::getAppId, (Object)appAuthorizeDto.getAppId());
        this.remove((Wrapper)queryWrapper);
        if (HussarUtils.isEmpty((Object)sysAppAuthorizationDto)) {
            return true;
        }
        ArrayList appAuthorizeList = Lists.newArrayListWithCapacity((int)10);
        for (SysAppAuthorizationDto authorization : sysAppAuthorizationDto) {
            SysAppVisitAuthorization appAuthorizeT = new SysAppVisitAuthorization();
            appAuthorizeT.setAppId(appAuthorizeDto.getAppId());
            appAuthorizeT.setRoleId(authorization.getId());
            appAuthorizeT.setAuthorizationType(authorization.getType());
            appAuthorizeList.add(appAuthorizeT);
        }
        this.sysAppOperationLogService.saveAppOperation(appAuthorizeDto.getAppId(), ROLE_TYPE);
        boolean flag = this.saveBatch(appAuthorizeList);
        SysApplication app = (SysApplication)this.sysApplicationCommonMapper.selectById(appAuthorizeDto.getAppId());
        HussarAppVisitAuthCallBackFactory.addAuthorization(appAuthorizeDto, app.getAppType());
        return flag;
    }

    public ApiResponse<Map<String, List<SysAppRoleVo>>> getAppRoleList(Long appId) {
        List authorizes = this.sysAppVisitAuthorizationMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitAuthorization::getAppId, (Object)appId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        if (HussarUtils.isEmpty((Object)authorizes)) {
            return ApiResponse.success(new HashMap(), (String)"\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        return ApiResponse.success(this.getAuthorizationInfoByIds(authorizes));
    }

    public void addAppAuthorization(String type, Long appId, List<SysAppAuthorizationDto> appAuthorList, String appType) {
        if (HussarUtils.isEmpty((Object)appType)) {
            appType = ((SysApplication)this.sysApplicationCommonMapper.selectById(appId)).getAppType();
        }
        if ("0".equals(type)) {
            SysAppVisitAuthorization appAuthorize = new SysAppVisitAuthorization();
            appAuthorize.setAppId(appId);
            appAuthorize.setRoleId(Long.valueOf(-1L));
            appAuthorize.setAuthorizationType("5");
            this.save((BaseEntity)appAuthorize);
            SysAppAuthorizationDto appAuthorizationDto = new SysAppAuthorizationDto();
            appAuthorizationDto.setId(appAuthorize.getRoleId());
            appAuthorizationDto.setType(appAuthorize.getAuthorizationType());
            appAuthorList.add(appAuthorizationDto);
            SysAppVisitAuthorizeDto appAuthorizeDto = new SysAppVisitAuthorizeDto();
            appAuthorizeDto.setAppId(appId);
            appAuthorizeDto.setAppAuthorList(appAuthorList);
            HussarAppVisitAuthCallBackFactory.addAuthorization(appAuthorizeDto, appType);
        } else if (HussarUtils.isNotEmpty(appAuthorList)) {
            ArrayList appAuthorizeList = Lists.newArrayListWithCapacity((int)10);
            for (SysAppAuthorizationDto authorization : appAuthorList) {
                SysAppVisitAuthorization appAuthorizeT = new SysAppVisitAuthorization();
                appAuthorizeT.setAppId(appId);
                appAuthorizeT.setRoleId(authorization.getId());
                appAuthorizeT.setAuthorizationType(authorization.getType());
                appAuthorizeList.add(appAuthorizeT);
            }
            this.saveBatch(appAuthorizeList);
            SysAppVisitAuthorizeDto appAuthorizeDto = new SysAppVisitAuthorizeDto();
            appAuthorizeDto.setAppId(appId);
            appAuthorizeDto.setAppAuthorList(appAuthorList);
            HussarAppVisitAuthCallBackFactory.addAuthorization(appAuthorizeDto, appType);
        }
    }

    public Map<String, List<SysAppRoleVo>> getAuthorizationInfoByIds(List<SysAppVisitAuthorization> authorizes) {
        List organIds = authorizes.stream().filter(s -> s.getAuthorizationType() != null && s.getAuthorizationType().equals(ORGAN_TYPE)).map(SysAppVisitAuthorization::getRoleId).collect(Collectors.toList());
        List postIds = authorizes.stream().filter(s -> s.getAuthorizationType() != null && s.getAuthorizationType().equals(POST_TYPE)).map(SysAppVisitAuthorization::getRoleId).collect(Collectors.toList());
        List userIds = authorizes.stream().filter(s -> s.getAuthorizationType() != null && s.getAuthorizationType().equals(USERS_TYPE)).map(SysAppVisitAuthorization::getRoleId).collect(Collectors.toList());
        List roleIds = authorizes.stream().filter(s -> s.getAuthorizationType() != null && s.getAuthorizationType().equals(ROLE_TYPE)).map(SysAppVisitAuthorization::getRoleId).collect(Collectors.toList());
        ArrayList<SysAppRoleVo> organsList = new ArrayList<SysAppRoleVo>();
        ArrayList<SysAppRoleVo> rolesList = new ArrayList<SysAppRoleVo>();
        ArrayList<SysAppRoleVo> postsList = new ArrayList<SysAppRoleVo>();
        ArrayList<SysAppRoleVo> usersList = new ArrayList<SysAppRoleVo>();
        List organs = new ArrayList();
        if (HussarUtils.isNotEmpty(organIds)) {
            organs = this.organizationBoService.getSimpleOrganByIds(organIds);
        }
        if (HussarUtils.isNotEmpty(organs)) {
            for (Object organ : organs) {
                SysAppRoleVo roleVo = new SysAppRoleVo();
                roleVo.setId(Long.valueOf(organ.getId()));
                roleVo.setRoleName(organ.getLabel());
                roleVo.setType(ORGAN_TYPE);
                organsList.add(roleVo);
            }
        }
        List roles = new ArrayList();
        if (HussarUtils.isNotEmpty(roleIds)) {
            roles = this.sysRolesService.getRoleInfoByIds(roleIds);
        }
        if (HussarUtils.isNotEmpty(roles)) {
            for (Object role : roles) {
                SysAppRoleVo roleVo = new SysAppRoleVo();
                roleVo.setId(role.getId());
                roleVo.setRoleName(role.getRoleName());
                roleVo.setType(ROLE_TYPE);
                rolesList.add(roleVo);
            }
        }
        List posts = new ArrayList();
        if (HussarUtils.isNotEmpty(postIds)) {
            posts = this.postBoService.getPostInfoByIds(postIds);
        }
        if (HussarUtils.isNotEmpty(posts)) {
            for (Object post : posts) {
                SysAppRoleVo roleVo = new SysAppRoleVo();
                roleVo.setId(post.getPostId());
                roleVo.setRoleName(post.getPostName());
                roleVo.setType(POST_TYPE);
                postsList.add(roleVo);
            }
        }
        List users = new ArrayList();
        if (HussarUtils.isNotEmpty(userIds)) {
            users = this.userBoService.getUsersByOrganUser(null, userIds);
        }
        if (HussarUtils.isNotEmpty(users)) {
            for (UserVo user : users) {
                SysAppRoleVo roleVo = new SysAppRoleVo();
                roleVo.setId(user.getId());
                roleVo.setRoleName(user.getUserName());
                roleVo.setType(USERS_TYPE);
                usersList.add(roleVo);
            }
        }
        HashMap<String, List<SysAppRoleVo>> resultMap = new HashMap<String, List<SysAppRoleVo>>();
        resultMap.put("organs", organsList);
        resultMap.put("roles", rolesList);
        resultMap.put("posts", postsList);
        resultMap.put("users", usersList);
        return resultMap;
    }
}

