/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeamMember;
import com.jxdinfo.hussar.application.service.ISysAppDevelopTeamMemberService;
import com.jxdinfo.hussar.application.service.ISysAppDevelopTeamService;
import com.jxdinfo.hussar.application.service.ISysAppVerifyService;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.constant.tenant.TenantConstant;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.application.service.impl.SysAppVerifyServiceImpl")
public class SysAppVerifyServiceImpl
implements ISysAppVerifyService {
    @Autowired
    private ISysAppDevelopTeamMemberService appDevelopTeamMemberService;
    @Autowired
    private ISysAppDevelopTeamService developTeamService;

    public Boolean checkPermissions(Long appId) {
        SecurityUser user = BaseSecurityUtil.getUser();
        if (HussarUtils.isEmpty((Object)user) || HussarUtils.equals((Object)user.getId(), (Object)SysUserAndRole.SUPERADMIN.getValue()) || user.getRolesList().contains(TenantConstant.ADMIN_ROLE)) {
            return true;
        }
        List appIds = this.developTeamService.selectAppListByCurrentUser();
        return HussarUtils.isNotEmpty((Object)appIds) && appIds.contains(appId);
    }

    public Boolean checkAdministrator(Long teamId) {
        SecurityUser user = BaseSecurityUtil.getUser();
        if (HussarUtils.equals((Object)user.getId(), (Object)SysUserAndRole.SUPERADMIN.getValue()) || user.getRolesList().contains(TenantConstant.ADMIN_ROLE)) {
            return true;
        }
        Long currentUserId = user.getId();
        SysAppDevelopTeamMember member = (SysAppDevelopTeamMember)this.appDevelopTeamMemberService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeamMember::getTeamId, (Object)teamId)).eq(SysAppDevelopTeamMember::getUserId, (Object)currentUserId)).or()).eq(SysAppDevelopTeamMember::getUserId, (Object)-1));
        if (member.getUserId() == -1L) {
            return true;
        }
        return HussarUtils.isNotEmpty((Object)member) && member.getMemberType() == 1;
    }

    public Boolean checkPermissionForMember(Long teamId) {
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user.isSuperAdmin() || user.getRolesList().contains(TenantConstant.ADMIN_ROLE)) {
            return true;
        }
        Long currentUserId = user.getId();
        SysAppDevelopTeamMember member = (SysAppDevelopTeamMember)this.appDevelopTeamMemberService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeamMember::getTeamId, (Object)teamId)).eq(SysAppDevelopTeamMember::getUserId, (Object)currentUserId)).or()).eq(SysAppDevelopTeamMember::getUserId, (Object)-1));
        if (member.getUserId() == -1L) {
            return true;
        }
        return HussarUtils.isNotEmpty((Object)member) && (member.getMemberType() == 1 || member.getMemberType() == 2);
    }
}

