/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.factory;

import com.jxdinfo.hussar.application.model.SysAppRecycle;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.IHussarAppCallBackService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class HussarApplicationCallBackFactory
implements ApplicationContextAware {
    private static final Map<String, IHussarAppCallBackService> map = new HashMap<String, IHussarAppCallBackService>();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map beanMap = applicationContext.getBeansOfType(IHussarAppCallBackService.class);
        this.setBeansToMap(beanMap);
    }

    private void setBeansToMap(Map<String, IHussarAppCallBackService> beanMap) {
        for (IHussarAppCallBackService appCallBackService : beanMap.values()) {
            map.put(appCallBackService.getAppType(), appCallBackService);
        }
    }

    public static IHussarAppCallBackService getAppCallBackService(String appType) {
        IHussarAppCallBackService appCallBackService = map.get(appType);
        return ToolUtil.isEmpty((Object)appCallBackService) ? map.get("default") : appCallBackService;
    }

    public static void addCallback(SysApplication app) {
        HussarApplicationCallBackFactory.getAppCallBackService(app.getAppType()).addApp(app);
    }

    public static void deleteApp(SysApplication app) {
        HussarApplicationCallBackFactory.getAppCallBackService(app.getAppType()).deleteApp(app);
    }

    public static void beforeDeleteApp(SysApplication app) {
        HussarApplicationCallBackFactory.getAppCallBackService(app.getAppType()).beforeDeleteApp(app);
    }

    public static void updateApp(SysApplication app) {
        HussarApplicationCallBackFactory.getAppCallBackService(app.getAppType()).updateApp(app);
    }

    public static void deleteRecycleApp(SysAppRecycle appRecycle) {
        HussarApplicationCallBackFactory.getAppCallBackService(appRecycle.getAppType()).deleteRecycleApp(appRecycle);
    }

    public static void revertRecycleApp(SysAppRecycle appRecycle) {
        HussarApplicationCallBackFactory.getAppCallBackService(appRecycle.getAppType()).revertRecycleApp(appRecycle);
    }

    public static void beforeDeleteRecycleApp(SysAppRecycle appRecycle) {
        HussarApplicationCallBackFactory.getAppCallBackService(appRecycle.getAppType()).beforeDeleteRecycleApp(appRecycle);
    }
}

