/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.application.dto.ApplicationRecordDto;
import com.jxdinfo.hussar.application.service.ISysApplicationRecordService;
import com.jxdinfo.hussar.application.vo.ApplicationRecordVo;
import com.jxdinfo.hussar.application.vo.ExportStatusVo;
import com.jxdinfo.hussar.application.vo.ImportStatusVo;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5e94\u7528\u5bfc\u5165\u5bfc\u51fa\u8bb0\u5f55"})
@RestController(value="com.jxdinfo.hussar.application.controller.SysApplicationRecordController")
@RequestMapping(value={"/hussarBase/application/record"})
public class SysApplicationRecordController {
    @Resource
    private ISysApplicationRecordService sysApplicationRecordService;

    @ApiOperation(value="\u65b0\u589e\u5e94\u7528\u5bfc\u5165\u5bfc\u51fa\u8bb0\u5f55", notes="\u65b0\u589e\u5e94\u7528\u5bfc\u5165\u5bfc\u51fa\u8bb0\u5f55")
    @GetMapping(value={"/newApplicationRecord"})
    @AuditLog(moduleName="\u5e94\u7528\u7ba1\u7406", eventDesc="\u65b0\u589e\u5e94\u7528\u5bfc\u5165\u5bfc\u51fa\u8bb0\u5f55", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Long> newApplicationRecord(@ApiParam(value="\u5bfc\u5165\u5bfc\u51fa\u7c7b\u578b") @RequestParam String recordType, @ApiParam(value="\u5e94\u7528id") @RequestParam(value="appId") Long appId, @ApiParam(value="\u5e94\u7528\u7c7b\u578b") String appMode, @ApiParam(value="\u64cd\u4f5c\u4ebaID") @RequestParam Long creatorId, String recordFilePwd) {
        return ApiResponse.success((Object)this.sysApplicationRecordService.newApplicationRecord(recordType, appId, appMode, creatorId, recordFilePwd));
    }

    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u5e94\u7528\u5bfc\u5165\u5bfc\u51fa\u8bb0\u5f55\u4fe1\u606f", notes="\u6839\u636eid\u67e5\u8be2\u5e94\u7528\u5bfc\u5165\u5bfc\u51fa\u8bb0\u5f55\u4fe1\u606f")
    @GetMapping(value={"/searchApplicationRecord"})
    @AuditLog(moduleName="\u5e94\u7528\u5bfc\u5165\u5bfc\u51fa\u8bb0\u5f55", eventDesc="\u6839\u636eid\u67e5\u8be2\u5e94\u7528\u5bfc\u5165\u5bfc\u51fa\u8bb0\u5f55\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<ApplicationRecordVo> searchApplicationRecord(@ApiParam(value="\u8bb0\u5f55ID") @RequestParam Long recordId) {
        return ApiResponse.success((Object)this.sysApplicationRecordService.getApplicationRecordById(recordId));
    }

    @ApiOperation(value="\u67e5\u8be2\u5e94\u7528\u5bfc\u5165\u5bfc\u51fa\u8bb0\u5f55\u5217\u8868", notes="\u67e5\u8be2\u5e94\u7528\u5bfc\u5165\u5bfc\u51fa\u8bb0\u5f55\u5217\u8868")
    @GetMapping(value={"/getAppRecordVoList"})
    @AuditLog(moduleName="\u5e94\u7528\u5bfc\u5165\u5bfc\u51fa\u8bb0\u5f55", eventDesc="\u67e5\u8be2\u5e94\u7528\u5bfc\u5165\u5bfc\u51fa\u8bb0\u5f55\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<ApplicationRecordVo>> getAppRecordVoList(@ApiParam(value="\u5206\u9875\u4fe1\u606f") PageInfo pageInfo, @ApiParam(value="\u5e94\u7528\u4efb\u52a1DTO") ApplicationRecordDto applicationRecordDto) {
        return ApiResponse.success((Object)this.sysApplicationRecordService.getApplicationRecordVoList(pageInfo, applicationRecordDto));
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5e94\u7528\u5bfc\u5165\u5bfc\u51fa\u8bb0\u5f55", notes="\u6279\u91cf\u5220\u9664\u5e94\u7528\u5bfc\u5165\u5bfc\u51fa\u8bb0\u5f55")
    @PostMapping(value={"/batchDeleteAppRecords"})
    @AuditLog(moduleName="\u5e94\u7528\u5bfc\u5165\u5bfc\u51fa\u8bb0\u5f55", eventDesc="\u6279\u91cf\u5220\u9664\u5e94\u7528\u5bfc\u5165\u5bfc\u51fa\u8bb0\u5f55", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<Object> batchDeleteAppRecords(@ApiParam(value="\u5220\u9664") @RequestBody String recordIds) {
        this.sysApplicationRecordService.batchDeleteAppRecords(recordIds);
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @GetMapping(value={"/export_progress"})
    @ApiOperation(value="\u83b7\u53d6\u5bfc\u51fa\u5e94\u7528\u8fdb\u5ea6")
    public ApiResponse<ExportStatusVo> getExportProgress(@RequestParam String exportCacheKey) {
        return this.sysApplicationRecordService.getExportProgress(exportCacheKey);
    }

    @GetMapping(value={"/import_progress"})
    @ApiOperation(value="\u83b7\u53d6\u5bfc\u51fa\u5e94\u7528\u8fdb\u5ea6")
    public ApiResponse<ImportStatusVo> getImportProgress(@RequestParam String importCacheKey) {
        return this.sysApplicationRecordService.getImportProgress(importCacheKey);
    }

    @GetMapping(value={"/downloadAppExportFile"})
    @ApiOperation(value="\u5e94\u7528\u5bfc\u51fa\u6587\u4ef6\u4e0b\u8f7d", notes="\u5e94\u7528\u5bfc\u51fa\u6587\u4ef6\u4e0b\u8f7d")
    public void downloadAppExportFile(@ApiParam(value="\u6587\u4ef6id") @RequestParam Long fileId, HttpServletResponse response) {
        this.sysApplicationRecordService.downloadAppExportFile(fileId, response);
    }
}

