/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.service.impl;

import com.jxdinfo.hussar.application.dao.SysAppDevelopTeamMemberCommonMapper;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeamMember;
import com.jxdinfo.hussar.application.service.ISysAppDevelopTeamMemberService;
import com.jxdinfo.hussar.application.vo.TeamMemberVo;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationBoService;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.vo.UserOrganPostVo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.application.service.impl.sysAppDevelopTeamMemberServiceImpl")
public class SysAppDevelopTeamMemberServiceImpl
extends HussarServiceImpl<SysAppDevelopTeamMemberCommonMapper, SysAppDevelopTeamMember>
implements ISysAppDevelopTeamMemberService {
    @Resource
    private SysAppDevelopTeamMemberCommonMapper sysAppDevelopTeamMemberCommonMapper;
    @Autowired
    private IHussarBaseUserBoService userBoService;
    @Autowired
    private IHussarBaseOrganizationBoService hussarBaseOrganizationBoService;

    public List<TeamMemberVo> listAppDevelopTeamMember(Long teamId) {
        List<TeamMemberVo> userVoList = this.sysAppDevelopTeamMemberCommonMapper.listAppDevelopTeamMember(teamId);
        if (HussarUtils.isNotEmpty(userVoList)) {
            List userIdList = userVoList.stream().map(TeamMemberVo::getId).collect(Collectors.toList());
            Map userInfoMap = this.userBoService.getUserInfo(userIdList);
            List organByUserIds = this.hussarBaseOrganizationBoService.getOrganByUserIds(userIdList);
            Map<Long, List<UserOrganPostVo>> userOrganMap = organByUserIds.stream().collect(Collectors.groupingBy(UserOrganPostVo::getUserId));
            for (TeamMemberVo item : userVoList) {
                SysUsers sysUsers = (SysUsers)userInfoMap.get(item.getId());
                if (HussarUtils.isNotEmpty((Object)sysUsers)) {
                    item.setUserName(sysUsers.getUserName());
                }
                List<UserOrganPostVo> userOrganPostVos = userOrganMap.get(item.getId());
                String organFNames = null;
                if (HussarUtils.isNotEmpty(userOrganPostVos)) {
                    organFNames = userOrganPostVos.stream().map(UserOrganPostVo::getOrganFname).collect(Collectors.joining(","));
                }
                item.setOrganFname(organFNames);
            }
        }
        return userVoList;
    }

    public List<TeamMemberVo> listAppTeamMember(Long teamId) {
        List<TeamMemberVo> userVoList = this.sysAppDevelopTeamMemberCommonMapper.listAppTeamMember(teamId);
        if (HussarUtils.isNotEmpty(userVoList)) {
            List userIdList = userVoList.stream().map(TeamMemberVo::getId).collect(Collectors.toList());
            Map userInfoMap = this.userBoService.getUserInfo(userIdList);
            List organByUserIds = this.hussarBaseOrganizationBoService.getOrganByUserIds(userIdList);
            Map<Long, List<UserOrganPostVo>> userOrganMap = organByUserIds.stream().collect(Collectors.groupingBy(UserOrganPostVo::getUserId));
            for (TeamMemberVo item : userVoList) {
                SysUsers sysUsers = (SysUsers)userInfoMap.get(item.getId());
                if (HussarUtils.isNotEmpty((Object)sysUsers)) {
                    item.setUserName(sysUsers.getUserName());
                }
                List<UserOrganPostVo> userOrganPostVos = userOrganMap.get(item.getId());
                String organFNames = null;
                if (HussarUtils.isNotEmpty(userOrganPostVos)) {
                    organFNames = userOrganPostVos.stream().map(UserOrganPostVo::getOrganFname).collect(Collectors.joining(","));
                }
                item.setOrganFname(organFNames);
            }
        }
        return userVoList;
    }
}

