/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.factory;

import com.jxdinfo.hussar.application.service.IHussarAppRoleCallBackService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class HussarApplicationRoleCallBackFactory
implements ApplicationContextAware {
    private static final Map<String, IHussarAppRoleCallBackService> map = new HashMap<String, IHussarAppRoleCallBackService>();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map beanMap = applicationContext.getBeansOfType(IHussarAppRoleCallBackService.class);
        this.setBeansToMap(beanMap);
    }

    private void setBeansToMap(Map<String, IHussarAppRoleCallBackService> beanMap) {
        for (IHussarAppRoleCallBackService appRoleCallBackService : beanMap.values()) {
            map.put(appRoleCallBackService.getAppType(), appRoleCallBackService);
        }
    }

    public static IHussarAppRoleCallBackService getAppRoleCallBackService(String appType) {
        IHussarAppRoleCallBackService appRoleCallBackService = map.get(appType);
        return ToolUtil.isEmpty((Object)appRoleCallBackService) ? map.get("default") : appRoleCallBackService;
    }

    public static void delAppRole(Long roleId, String appType) {
        HussarApplicationRoleCallBackFactory.getAppRoleCallBackService(appType).delAppRole(roleId, appType);
    }

    public static void copyAppRole(Long sourceRoleId, Long targetRoleId, String appType) {
        HussarApplicationRoleCallBackFactory.getAppRoleCallBackService(appType).copyAppRole(sourceRoleId, targetRoleId, appType);
    }
}

