/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.factory;

import com.jxdinfo.hussar.application.dto.AppDevelopTeamDto;
import com.jxdinfo.hussar.application.dto.TransferMemberTypeDto;
import com.jxdinfo.hussar.application.dto.UpdateMemberTypeDto;
import com.jxdinfo.hussar.application.service.IHussarAppTeamCallBackService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class HussarApplicationTeamCallBackFactory
implements ApplicationContextAware {
    private static final Map<String, IHussarAppTeamCallBackService> map = new HashMap<String, IHussarAppTeamCallBackService>();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map beanMap = applicationContext.getBeansOfType(IHussarAppTeamCallBackService.class);
        this.setBeansToMap(beanMap);
    }

    private void setBeansToMap(Map<String, IHussarAppTeamCallBackService> beanMap) {
        for (IHussarAppTeamCallBackService appTeamCallBackService : beanMap.values()) {
            map.put(appTeamCallBackService.getAppType(), appTeamCallBackService);
        }
    }

    public static IHussarAppTeamCallBackService getAppTeamCallBackService(String appType) {
        IHussarAppTeamCallBackService appTeamCallBackService = map.get(appType);
        return ToolUtil.isEmpty((Object)appTeamCallBackService) ? map.get("default") : appTeamCallBackService;
    }

    public static void saveAppDevelopTeam(AppDevelopTeamDto appDevelopTeamDto, String appType) {
        HussarApplicationTeamCallBackFactory.getAppTeamCallBackService(appType).saveAppDevelopTeam(appDevelopTeamDto);
    }

    public static void updateAppDevelopTeam(AppDevelopTeamDto appDevelopTeamDto, String appType) {
        HussarApplicationTeamCallBackFactory.getAppTeamCallBackService(appType).updateAppDevelopTeam(appDevelopTeamDto, appType);
    }

    public static void updateMember(UpdateMemberTypeDto updateDto, String appType) {
        HussarApplicationTeamCallBackFactory.getAppTeamCallBackService(appType).updateMember(updateDto);
    }

    public static void removeMembers(Long appId, Long userId, String appType) {
        HussarApplicationTeamCallBackFactory.getAppTeamCallBackService(appType).removeMembers(appId, userId);
    }

    public static void transferAdministrator(TransferMemberTypeDto transferDto, String appType) {
        HussarApplicationTeamCallBackFactory.getAppTeamCallBackService(appType).transferAdministrator(transferDto);
    }
}

