/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.application.dao.SysAppClientMapper;
import com.jxdinfo.hussar.application.dao.SysAppDevelopTeamCommonMapper;
import com.jxdinfo.hussar.application.dao.SysAppDevelopTeamMemberCommonMapper;
import com.jxdinfo.hussar.application.dao.SysAppRecycleCommonMapper;
import com.jxdinfo.hussar.application.enums.SysUserRoleEnum;
import com.jxdinfo.hussar.application.factory.HussarApplicationCallBackFactory;
import com.jxdinfo.hussar.application.model.SysAppClient;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeam;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeamMember;
import com.jxdinfo.hussar.application.model.SysAppRecycle;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysAppGroupService;
import com.jxdinfo.hussar.application.service.ISysAppRecycleService;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.application.vo.SysAppRecycleVo;
import com.jxdinfo.hussar.authentication.service.SysAuthClientModelService;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.application.service.impl.SysAppRecycleServiceImpl")
public class SysAppRecycleServiceImpl
extends HussarServiceImpl<SysAppRecycleCommonMapper, SysAppRecycle>
implements ISysAppRecycleService {
    @Autowired
    private ISysApplicationService sysApplicationService;
    @Resource
    private SysAppRecycleCommonMapper sysAppRecycleCommonMapper;
    @Autowired
    private ISysAppGroupService sysAppGroupService;
    @Resource
    private SysAppDevelopTeamCommonMapper developTeamMapper;
    @Resource
    private SysAppDevelopTeamMemberCommonMapper developTeamMemberMapper;
    @Resource
    private SysAppClientMapper sysAppClientMapper;
    @Autowired
    private SysAuthClientModelService sysAuthClientModelService;

    public Page<SysAppRecycleVo> getRecycleList(PageInfo pageInfo, String appName) {
        Page<SysAppRecycleVo> result;
        List appRecycleVoList;
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = null;
        if (!user.isSuperAdmin() && !user.getRolesList().contains(SysUserRoleEnum.TENANT_ROLE.getValue())) {
            userId = user.getUserId();
        }
        if (HussarUtils.isNotEmpty((Object)(appRecycleVoList = (result = this.sysAppRecycleCommonMapper.getRecycleList((Page<SysAppRecycleVo>)page, userId, appName)).getRecords()))) {
            List list = appRecycleVoList.stream().map(SysAppRecycleVo::getUserId).collect(Collectors.toList());
        }
        return result;
    }

    @HussarTransactional
    public Boolean revertApp(Long appId) {
        SysAppRecycle revertApp = (SysAppRecycle)this.getById(appId);
        if (HussarUtils.isEmpty((Object)this.sysAppGroupService.getById((Serializable)revertApp.getAppGroupId()))) {
            revertApp.setAppGroupId(Long.valueOf(1L));
        }
        SysApplication sysApplication = new SysApplication();
        BeanUtils.copyProperties((Object)revertApp, (Object)sysApplication);
        sysApplication.setAppStatus("1");
        sysApplication.setReleaseStatus("0");
        sysApplication.setCreator(revertApp.getCreateUser());
        sysApplication.setLastEditor(revertApp.getCreateUser());
        this.sysApplicationService.save((Object)sysApplication);
        return this.removeById(appId);
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public Boolean deleteRecycleApp(Long appId) {
        SysAppDevelopTeam sysAppDevelopTeam = (SysAppDevelopTeam)this.developTeamMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeam::getAppId, (Object)appId));
        this.developTeamMapper.deleteById(sysAppDevelopTeam.getId());
        this.developTeamMemberMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeamMember::getTeamId, (Object)sysAppDevelopTeam.getId()));
        SysAppClient appClient = (SysAppClient)this.sysAppClientMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysAppClient::getAppId, (Object)appId));
        if (HussarUtils.isNotEmpty((Object)appClient)) {
            this.sysAuthClientModelService.deleteAuthClientModel(appClient.getClientModelId());
            this.sysAppClientMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysAppClient::getAppId, (Object)appId));
        }
        SysAppRecycle appRecycle = (SysAppRecycle)this.getById(appId);
        boolean flag = this.removeById(appId);
        HussarApplicationCallBackFactory.deleteRecycleApp(appRecycle);
        HussarCacheUtil.evict((String)"iam_sdk", (Object)"clientId_appId_map");
        return flag;
    }
}

