/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.jxdinfo.hussar.application.dao.SysAppDevelopTeamCommonMapper;
import com.jxdinfo.hussar.application.dao.SysAppGroupCommonMapper;
import com.jxdinfo.hussar.application.dao.SysApplicationCommonMapper;
import com.jxdinfo.hussar.application.dto.AppDevelopTeamDto;
import com.jxdinfo.hussar.application.dto.SysApplicationDto;
import com.jxdinfo.hussar.application.enums.SysUserRoleEnum;
import com.jxdinfo.hussar.application.factory.HussarApplicationCallBackFactory;
import com.jxdinfo.hussar.application.model.SysAppClient;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeam;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeamMember;
import com.jxdinfo.hussar.application.model.SysAppGroup;
import com.jxdinfo.hussar.application.model.SysAppRecycle;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysAppClientService;
import com.jxdinfo.hussar.application.service.ISysAppDevelopTeamMemberService;
import com.jxdinfo.hussar.application.service.ISysAppDevelopTeamService;
import com.jxdinfo.hussar.application.service.ISysAppGroupService;
import com.jxdinfo.hussar.application.service.ISysAppOperationLogService;
import com.jxdinfo.hussar.application.service.ISysAppRecycleService;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.application.vo.SysAppGroupVo;
import com.jxdinfo.hussar.application.vo.SysApplicationClientInfoVo;
import com.jxdinfo.hussar.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.authentication.service.SysAuthClientModelService;
import com.jxdinfo.hussar.base.cloud.model.client.SysAuthClientModel;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.core.util.PingYinUtil;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import com.jxdinfo.hussar.platform.core.utils.random.RandomUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.application.service.impl.SysApplicationServiceImpl")
public class SysApplicationServiceImpl
extends HussarServiceImpl<SysApplicationCommonMapper, SysApplication>
implements ISysApplicationService {
    private static final String TEAMNAME_SUFFIX = "\u5f00\u53d1\u56e2\u961f";
    @Resource
    private SysApplicationCommonMapper sysApplicationCommonMapper;
    @Resource
    private SysAppGroupCommonMapper sysAppGroupCommonMapper;
    @Resource
    private SysAppDevelopTeamCommonMapper developTeamMapper;
    @Autowired
    private ISysIdtableService sysIdTableService;
    @Autowired
    private ISysAppRecycleService sysAppRecycleService;
    @Autowired
    private ISysAppGroupService sysAppGroupService;
    @Autowired
    private ISysAppDevelopTeamService developTeamService;
    @Autowired
    private SysAuthClientModelService sysAuthClientModelService;
    @Autowired
    private ISysAppClientService sysAppClientService;
    @Autowired
    private ISysAppDevelopTeamMemberService sysAppDevelopTeamMemberService;
    @Autowired
    private ISysAppOperationLogService sysAppOperationLogService;

    public List<SysAppGroupVo> getManageAppList(Long appGroupId, String appName) {
        ArrayList appListVo = Lists.newArrayListWithCapacity((int)10);
        SecurityUser user = BaseSecurityUtil.getUser();
        List<SysApplicationVo> appList = null;
        List<Object> sysAppGroups = new ArrayList<SysAppGroup>();
        if (user.isSuperAdmin() || user.getRolesList().contains(SysUserRoleEnum.TENANT_ROLE.getValue())) {
            appList = this.sysApplicationCommonMapper.getAppListManage(appGroupId, appName, null);
            LinkedHashSet groupIds = Sets.newLinkedHashSetWithExpectedSize((int)10);
            for (SysApplication sysApplication : appList) {
                groupIds.add(sysApplication.getAppGroupId());
            }
            if (HussarUtils.isNotEmpty((Object)groupIds)) {
                sysAppGroups = this.sysAppGroupCommonMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysAppGroup::getId, (Collection)groupIds));
            }
        } else {
            List appIds = this.developTeamService.selectAppListByCurrentUser();
            if (HussarUtils.isEmpty((Object)appIds)) {
                return Collections.emptyList();
            }
            appList = this.sysApplicationCommonMapper.getAppListManage(appGroupId, appName, appIds);
            if (HussarUtils.isEmpty(appList)) {
                return Collections.emptyList();
            }
            Set groupIds = appList.stream().map(SysApplication::getAppGroupId).collect(Collectors.toSet());
            sysAppGroups = this.sysAppGroupCommonMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysAppGroup::getId, groupIds));
        }
        this.setUserInfo(appList);
        this.initAppList(appList);
        return this.combinedData(appList, sysAppGroups);
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public Boolean addApp(SysApplicationDto sysApplicationDto) {
        List appName = this.list((Wrapper)new LambdaQueryWrapper().eq(SysApplication::getAppName, (Object)sysApplicationDto.getAppName()));
        if (HussarUtils.isNotEmpty((Object)appName)) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01(\u5e94\u7528\u540d\u79f0\u5df2\u5b58\u5728\uff01)");
        }
        Long appId = IdWorker.getId((Object)new SysApplicationDto());
        sysApplicationDto.setId(appId);
        if (HussarUtils.isEmpty((Object)sysApplicationDto.getAppStatus())) {
            sysApplicationDto.setAppStatus("1");
        }
        if (HussarUtils.isEmpty((Object)sysApplicationDto.getReleaseStatus())) {
            sysApplicationDto.setReleaseStatus("0");
        }
        sysApplicationDto.setSecretKey(IdUtil.randomUUID().replace("-", ""));
        if (HussarUtils.isEmpty((Object)sysApplicationDto.getAppCode())) {
            String currentCode = this.sysIdTableService.getCurrentCode("APP_CODE", "SYS_APPLICATION");
            sysApplicationDto.setAppCode(currentCode);
        }
        if (sysApplicationDto.getOpenClient().booleanValue()) {
            SysAuthClientModel sysAuthClientModel = new SysAuthClientModel();
            String accessId = RandomUtil.randomNumbers((int)10);
            String scope = PingYinUtil.getPYIndexStr((String)sysApplicationDto.getAppName(), (boolean)true) + "_" + sysApplicationDto.getAppCode();
            sysAuthClientModel.setClientId(accessId);
            sysAuthClientModel.setClientSecret(sysApplicationDto.getSecretKey());
            sysAuthClientModel.setAllowUrl("*");
            sysAuthClientModel.setContractScope(scope);
            sysAuthClientModel.setAuthorizedGrantType("client_credentials");
            sysAuthClientModel.setAccessTokenValidTime(1800L);
            sysAuthClientModel.setRefreshTokenValidTime(86400L);
            try {
                ApiResponse response = this.sysAuthClientModelService.saveAuthClientModel(sysAuthClientModel);
                SysAuthClientModel data = (SysAuthClientModel)response.getData();
                SysAppClient appClient = new SysAppClient();
                appClient.setAppId(appId);
                appClient.setClientModelId(data.getId());
                this.sysAppClientService.save((Object)appClient);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        String teamName = sysApplicationDto.getAppName() + TEAMNAME_SUFFIX;
        AppDevelopTeamDto developTeamDto = new AppDevelopTeamDto();
        developTeamDto.setAppId(appId);
        developTeamDto.setTeamName(teamName);
        developTeamDto.setUserIds(Arrays.asList(BaseSecurityUtil.getUser().getId()));
        developTeamDto.setOpenTeam(sysApplicationDto.getOpenTeam());
        this.developTeamService.saveAppDevelopTeam(developTeamDto);
        this.save((BaseEntity)sysApplicationDto);
        this.sysAppOperationLogService.saveAppOperation(appId);
        HussarApplicationCallBackFactory.addCallback((SysApplication)sysApplicationDto);
        HussarCacheUtil.evict((String)"iam_sdk", (Object)"clientId_appId_map");
        return Boolean.TRUE;
    }

    public Boolean updateApp(SysApplicationDto sysApplicationDto) {
        List appName;
        SysApplication sysApplication = (SysApplication)this.getOne((Wrapper)new LambdaQueryWrapper().eq(SysApplication::getId, (Object)sysApplicationDto.getId()));
        if (!Objects.equals(sysApplication.getAppName(), sysApplicationDto.getAppName()) && HussarUtils.isNotEmpty((Object)(appName = this.list((Wrapper)new LambdaQueryWrapper().eq(SysApplication::getAppName, (Object)sysApplicationDto.getAppName()))))) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01(\u5e94\u7528\u540d\u79f0\u5df2\u5b58\u5728\uff01)");
        }
        boolean flag = this.updateById((BaseEntity)sysApplicationDto);
        this.sysAppOperationLogService.saveAppOperation(sysApplicationDto.getId());
        HussarApplicationCallBackFactory.updateApp((SysApplication)sysApplicationDto);
        return flag;
    }

    @HussarTransactional
    public Boolean deleteApp(Long appId) {
        SysApplication appInfo = (SysApplication)this.getById(appId);
        SysAppRecycle sysAppRecycle = new SysAppRecycle();
        BeanUtils.copyProperties((Object)appInfo, (Object)sysAppRecycle);
        sysAppRecycle.setDeleteUser(BaseSecurityUtil.getUser().getUserId());
        sysAppRecycle.setCreateUser(BaseSecurityUtil.getUser().getUserId());
        sysAppRecycle.setDeleteTime(LocalDateTime.now());
        this.sysAppRecycleService.save((Object)sysAppRecycle);
        boolean flag = this.removeById(appId);
        HussarApplicationCallBackFactory.deleteApp(appInfo);
        return flag;
    }

    public ApiResponse<SysApplicationVo> getAppDetail(Long appId) {
        SysApplicationVo sysApplicationVo = this.sysApplicationCommonMapper.getAppDetail(appId);
        ArrayList<SysApplicationVo> sysApplicationVoList = new ArrayList<SysApplicationVo>();
        sysApplicationVoList.add(sysApplicationVo);
        this.setUserInfo(sysApplicationVoList);
        return ApiResponse.success((Object)sysApplicationVo);
    }

    public String getCurrentCode() {
        return String.valueOf(System.currentTimeMillis() / 1000L);
    }

    public List<SysApplicationVo> getLastApp() {
        List appIds = this.sysAppOperationLogService.getLastApp();
        if (HussarUtils.isEmpty((Object)appIds)) {
            return Collections.emptyList();
        }
        if (HussarUtils.isEmpty((Object)appIds)) {
            return Collections.emptyList();
        }
        List appList = this.list((Wrapper)new LambdaQueryWrapper().in(SysApplication::getId, (Collection)appIds));
        ArrayList<SysApplicationVo> voList = new ArrayList<SysApplicationVo>();
        block0: for (Long appId : appIds) {
            for (SysApplication application : appList) {
                if (!appId.equals(application.getId())) continue;
                SysApplicationVo vo = new SysApplicationVo();
                BeanUtils.copyProperties((Object)application, (Object)vo);
                voList.add(vo);
                continue block0;
            }
        }
        this.setUserInfo(voList);
        this.initAppList(voList);
        return voList;
    }

    public Page<SysApplicationVo> getManageAppPageList(PageInfo pageInfo, Long appGroupId, String appName) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        List<Object> appList = new ArrayList();
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user.isSuperAdmin() || user.getRolesList().contains(SysUserRoleEnum.TENANT_ROLE.getValue())) {
            appList = this.sysApplicationCommonMapper.getManageAppPageList((Page<SysApplicationVo>)page, appGroupId, appName, null);
        } else {
            List appIds = this.developTeamService.selectAppListByCurrentUser();
            if (HussarUtils.isEmpty((Object)appIds)) {
                page.setRecords(appList);
                return page;
            }
            appList = this.sysApplicationCommonMapper.getManageAppPageList((Page<SysApplicationVo>)page, appGroupId, appName, appIds);
            if (HussarUtils.isEmpty(appList)) {
                page.setRecords(appList);
                return page;
            }
        }
        this.setUserInfo(appList);
        this.initAppList(appList);
        page.setRecords(appList);
        return page;
    }

    public List<SysApplicationVo> getUserApplications(Long userId) {
        return this.sysApplicationCommonMapper.getUserApplications(userId);
    }

    private List<SysAppGroupVo> combinedData(List<SysApplicationVo> appList, List<SysAppGroup> sysAppGroups) {
        Map resultCollect = JSON.parseArray((String)JSON.toJSONString(sysAppGroups), SysAppGroupVo.class).stream().collect(Collectors.toMap(SysAppGroup::getId, sysAppGroupVo -> sysAppGroupVo, (k1, k2) -> k1, LinkedHashMap::new));
        for (SysApplicationVo sysApplication : appList) {
            SysAppGroupVo sysAppGroupVo2 = (SysAppGroupVo)resultCollect.get(sysApplication.getAppGroupId());
            if (HussarUtils.isEmpty((Object)sysAppGroupVo2)) continue;
            if (HussarUtils.isNotEmpty((Object)sysAppGroupVo2.getSysApplicationList())) {
                sysAppGroupVo2.getSysApplicationList().add(sysApplication);
            }
            if (!HussarUtils.isEmpty((Object)sysAppGroupVo2.getSysApplicationList())) continue;
            ArrayList<SysApplicationVo> sysApplicationList = new ArrayList<SysApplicationVo>();
            sysApplicationList.add(sysApplication);
            sysAppGroupVo2.setSysApplicationList(sysApplicationList);
        }
        return new ArrayList<SysAppGroupVo>(resultCollect.values());
    }

    private void setUserInfo(List<SysApplicationVo> appList) {
    }

    private void initAppList(List<SysApplicationVo> appList) {
        SecurityUser user = BaseSecurityUtil.getUser();
        List<Long> appIds = appList.stream().map(SysApplication::getId).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(appIds)) {
            List<SysAppDevelopTeam> sysAppDevelopTeams = this.developTeamMapper.selectAppDevelopTeamList(appIds);
            List teamIds = sysAppDevelopTeams.stream().map(SysAppDevelopTeam::getId).distinct().collect(Collectors.toList());
            List members = this.sysAppDevelopTeamMemberService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysAppDevelopTeamMember::getTeamId, teamIds)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
            Map<Long, List<SysAppDevelopTeamMember>> teamMemberMap = members.stream().collect(Collectors.groupingBy(SysAppDevelopTeamMember::getTeamId));
            Map teamUserIdMap = members.stream().collect(Collectors.groupingBy(SysAppDevelopTeamMember::getTeamId, Collectors.mapping(SysAppDevelopTeamMember::getUserId, Collectors.toList())));
            Map sysAppDevelopTeamMap = sysAppDevelopTeams.stream().collect(Collectors.toMap(SysAppDevelopTeam::getAppId, Function.identity()));
            Long currentUserId = user.getId();
            for (SysApplicationVo app : appList) {
                if (!HussarUtils.isNotEmpty(sysAppDevelopTeamMap.get(app.getId()))) continue;
                Long teamId = ((SysAppDevelopTeam)sysAppDevelopTeamMap.get(app.getId())).getId();
                if (user.isSuperAdmin() || user.getRolesList().contains(SysUserRoleEnum.TENANT_ROLE.getValue())) {
                    app.setMemberType(Integer.valueOf(1));
                } else {
                    List userIds = teamUserIdMap.get(teamId);
                    if (HussarUtils.isNotEmpty(userIds)) {
                        if (userIds.contains(currentUserId)) {
                            List<SysAppDevelopTeamMember> memberList = teamMemberMap.get(teamId);
                            SysAppDevelopTeamMember member = memberList.stream().filter(item -> item.getUserId().equals(currentUserId)).findFirst().get();
                            app.setMemberType(member.getMemberType());
                        }
                        if ((Long)userIds.get(0) == -1L) {
                            app.setMemberType(Integer.valueOf(1));
                        }
                    }
                }
                app.setTeamId(teamId);
            }
        }
    }

    public Page<SysApplicationVo> getUserAppList(PageInfo pageInfo, String appName) {
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getId();
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("appName", StringUtils.trimToEmpty((String)appName));
        queryParams.put("userId", userId);
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        List<SysApplicationVo> appList = this.sysApplicationCommonMapper.getUserAppList((Page<SysApplicationVo>)page, queryParams);
        page.setRecords(appList);
        return page;
    }

    public Boolean checkSameAppName(Long appId, String appName) {
        if (HussarUtils.isEmpty((Object)appId)) {
            List list = this.sysApplicationCommonMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysApplication::getAppName, (Object)appName));
            if (HussarUtils.isEmpty((Object)list)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        List list = this.sysApplicationCommonMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ne(SysApplication::getId, (Object)appId)).like(SysApplication::getAppName, (Object)appName));
        if (HussarUtils.isEmpty((Object)list)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public ApiResponse<SysApplicationClientInfoVo> getAppDetailClientInfo(Long appId) {
        ArrayList<SysApplicationVo> sysApplicationVoList = new ArrayList<SysApplicationVo>();
        SysApplicationVo sysApplicationVo = this.sysApplicationCommonMapper.getAppDetail(appId);
        sysApplicationVoList.add(sysApplicationVo);
        this.setUserInfo(sysApplicationVoList);
        SysApplicationClientInfoVo sysApplicationClientInfoVo = new SysApplicationClientInfoVo();
        BeanUtil.copyProperties((Object)sysApplicationVo, (Object)sysApplicationClientInfoVo);
        return ApiResponse.success((Object)sysApplicationClientInfoVo);
    }
}

