/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.service.impl;

import com.jxdinfo.hussar.application.dao.SysAppOperationLogMapper;
import com.jxdinfo.hussar.application.enums.SysUserRoleEnum;
import com.jxdinfo.hussar.application.model.SysAppOperationLog;
import com.jxdinfo.hussar.application.service.ISysAppDevelopTeamService;
import com.jxdinfo.hussar.application.service.ISysAppOperationLogService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.application.service.impl.sysAppOperationLogServiceImpl")
public class SysAppOperationLogServiceImpl
extends HussarServiceImpl<SysAppOperationLogMapper, SysAppOperationLog>
implements ISysAppOperationLogService {
    @Resource
    private SysAppOperationLogMapper sysAppOperationLogMapper;
    @Autowired
    private ISysAppDevelopTeamService developTeamService;

    public Boolean saveAppOperation(Long appId) {
        SysAppOperationLog appOperationLog = new SysAppOperationLog();
        appOperationLog.setAppId(appId);
        return this.save((BaseEntity)appOperationLog);
    }

    public List<Long> getLastApp() {
        List<Long> appIds;
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("userId", userId);
        if (user.isSuperAdmin() || user.getRolesList().contains(SysUserRoleEnum.TENANT_ROLE.getValue())) {
            appIds = this.sysAppOperationLogMapper.getLastApp(queryParams);
        } else {
            List appIdList = this.developTeamService.selectAppListByCurrentUser();
            if (HussarUtils.isEmpty((Object)appIdList)) {
                return Collections.emptyList();
            }
            queryParams.put("appIds", appIdList);
            appIds = this.sysAppOperationLogMapper.getLastApp(queryParams);
        }
        List<Long> list = appIds.stream().distinct().collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(list)) {
            if (list.size() > 6) {
                return list.subList(0, 6);
            }
            return list;
        }
        return Collections.emptyList();
    }
}

