/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.application.dao.SysAppDevelopTeamCommonMapper;
import com.jxdinfo.hussar.application.dto.AppDevelopTeamDto;
import com.jxdinfo.hussar.application.dto.TransferMemberTypeDto;
import com.jxdinfo.hussar.application.dto.UpdateMemberTypeDto;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeam;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeamMember;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysAppDevelopTeamMemberService;
import com.jxdinfo.hussar.application.service.ISysAppDevelopTeamService;
import com.jxdinfo.hussar.application.service.ISysAppOperationLogService;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.application.vo.AppDevelopTeamDetailVo;
import com.jxdinfo.hussar.authorization.organ.vo.RoleOrgUserVo;
import com.jxdinfo.hussar.authorization.permit.dto.RoleUserDto;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.application.service.impl.sysAppDevelopTeamServiceImpl")
public class SysAppDevelopTeamServiceImpl
extends HussarServiceImpl<SysAppDevelopTeamCommonMapper, SysAppDevelopTeam>
implements ISysAppDevelopTeamService {
    @Autowired
    private ISysAppDevelopTeamMemberService appDevelopTeamMemberService;
    @Resource
    private SysAppDevelopTeamCommonMapper sysAppDevelopTeamCommonMapper;
    @Autowired
    private ISysAppOperationLogService sysAppOperationLogService;
    @Resource
    private ISysApplicationService sysApplicationService;
    @Resource
    private ISysRolesExternalService sysRolesExternalService;

    @HussarTransactional
    public Boolean saveAppDevelopTeam(AppDevelopTeamDto appDevelopTeamDto) {
        SysAppDevelopTeam sysAppDevelopTeam = new SysAppDevelopTeam();
        BeanUtils.copyProperties((Object)appDevelopTeamDto, (Object)sysAppDevelopTeam);
        long id = IdWorker.getId((Object)sysAppDevelopTeam);
        List userIds = appDevelopTeamDto.getUserIds();
        if (appDevelopTeamDto.getOpenTeam().booleanValue()) {
            if (HussarUtils.isNotEmpty((Object)userIds)) {
                userIds = userIds.stream().distinct().collect(Collectors.toList());
                ArrayList<SysAppDevelopTeamMember> memberList = new ArrayList<SysAppDevelopTeamMember>();
                for (Long userId : userIds) {
                    SysAppDevelopTeamMember member = new SysAppDevelopTeamMember();
                    member.setTeamId(Long.valueOf(id));
                    member.setUserId(userId);
                    member.setMemberType(Integer.valueOf(1));
                    memberList.add(member);
                }
                this.appDevelopTeamMemberService.saveBatch(memberList);
            }
        } else {
            SysAppDevelopTeamMember member = new SysAppDevelopTeamMember();
            member.setTeamId(Long.valueOf(id));
            member.setUserId(Long.valueOf(-1L));
            member.setMemberType(Integer.valueOf(1));
            this.appDevelopTeamMemberService.save((Object)member);
        }
        sysAppDevelopTeam.setId(Long.valueOf(id));
        return this.save((BaseEntity)sysAppDevelopTeam);
    }

    @HussarTransactional
    public Boolean updateAppDevelopTeam(AppDevelopTeamDto appDevelopTeamDto) {
        List addUserIds;
        SysAppDevelopTeam sysAppDevelopTeam = new SysAppDevelopTeam();
        BeanUtils.copyProperties((Object)appDevelopTeamDto, (Object)sysAppDevelopTeam);
        Long teamId = appDevelopTeamDto.getTeamId();
        List newUserIds = appDevelopTeamDto.getUserIds();
        if (HussarUtils.isEmpty((Object)newUserIds)) {
            return false;
        }
        List oldUserVoList = this.appDevelopTeamMemberService.list((Wrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeamMember::getTeamId, (Object)teamId));
        List oldUserIds = oldUserVoList.stream().map(SysAppDevelopTeamMember::getUserId).distinct().collect(Collectors.toList());
        List<Object> delUserIds = new ArrayList();
        if (HussarUtils.isEmpty(oldUserIds)) {
            addUserIds = newUserIds;
        } else {
            addUserIds = newUserIds.stream().filter(item -> !oldUserIds.contains(item)).collect(Collectors.toList());
            delUserIds = oldUserIds.stream().filter(item -> !newUserIds.contains(item)).collect(Collectors.toList());
        }
        if (HussarUtils.isNotEmpty(delUserIds)) {
            this.appDevelopTeamMemberService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeamMember::getTeamId, (Object)teamId)).in(SysAppDevelopTeamMember::getUserId, delUserIds));
        }
        if (HussarUtils.isNotEmpty((Object)addUserIds)) {
            ArrayList<SysAppDevelopTeamMember> memberList = new ArrayList<SysAppDevelopTeamMember>();
            for (Long userId2 : addUserIds) {
                SysAppDevelopTeamMember member = new SysAppDevelopTeamMember();
                member.setTeamId(teamId);
                member.setUserId(userId2);
                member.setMemberType(Integer.valueOf(0));
                memberList.add(member);
            }
            this.appDevelopTeamMemberService.saveBatch(memberList);
        }
        sysAppDevelopTeam.setId(teamId);
        boolean flag = this.updateById((BaseEntity)sysAppDevelopTeam);
        SysApplication app = (SysApplication)this.sysApplicationService.getById((Serializable)appDevelopTeamDto.getAppId());
        if ("1".equals(app.getAppType())) {
            Long developRoleId = app.getDevelopRoleId();
            RoleUserDto roleUserDto = new RoleUserDto();
            roleUserDto.setRoleId(developRoleId);
            List removeList = oldUserVoList.stream().map(userVo -> {
                RoleOrgUserVo roleOrgUserVo = new RoleOrgUserVo();
                roleOrgUserVo.setId(userVo.getUserId());
                return roleOrgUserVo;
            }).collect(Collectors.toList());
            roleUserDto.setDels(removeList);
            List addList = newUserIds.stream().map(userId -> {
                RoleOrgUserVo roleOrgUserVo = new RoleOrgUserVo();
                roleOrgUserVo.setId(userId);
                return roleOrgUserVo;
            }).collect(Collectors.toList());
            roleUserDto.setAdds(addList);
            this.sysRolesExternalService.addOrDelAppDevRoleUser(roleUserDto).getData();
        }
        this.sysAppOperationLogService.saveAppOperation(appDevelopTeamDto.getAppId());
        return flag;
    }

    public ApiResponse<AppDevelopTeamDetailVo> getAppDevelopTeamDetail(Long appId) {
        AppDevelopTeamDetailVo teamDetailVo = new AppDevelopTeamDetailVo();
        SysAppDevelopTeam team = (SysAppDevelopTeam)this.getOne((Wrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeam::getAppId, (Object)appId));
        if (HussarUtils.isEmpty((Object)team)) {
            throw new BaseException("\u8be5\u5e94\u7528\u6ca1\u6709\u5e94\u7528\u5f00\u53d1\u56e2\u961f\uff01");
        }
        BeanUtils.copyProperties((Object)team, (Object)teamDetailVo);
        teamDetailVo.setTeamId(team.getId());
        List userVoList = this.appDevelopTeamMemberService.listAppDevelopTeamMember(team.getId());
        teamDetailVo.setUserList(userVoList);
        return ApiResponse.success((Object)teamDetailVo);
    }

    public List<Long> selectAppListByCurrentUser() {
        Long userId = BaseSecurityUtil.getUser().getId();
        return this.sysAppDevelopTeamCommonMapper.selectAppListByCurrentUser(userId);
    }

    public Boolean checkCurrentUserInTeam(Long appId) {
        List<Long> appIdList = this.selectAppListByCurrentUser();
        return appIdList.contains(appId);
    }

    @HussarTransactional
    public Boolean updateMemberType(UpdateMemberTypeDto updateDto) {
        SysAppDevelopTeamMember member = (SysAppDevelopTeamMember)this.appDevelopTeamMemberService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeamMember::getTeamId, (Object)updateDto.getTeamId())).eq(SysAppDevelopTeamMember::getUserId, (Object)updateDto.getUserId()));
        member.setMemberType(updateDto.getType());
        boolean update = this.appDevelopTeamMemberService.updateById((Object)member);
        this.sysAppOperationLogService.saveAppOperation(updateDto.getAppId());
        return update;
    }

    @HussarTransactional
    public Boolean transferMemberType(TransferMemberTypeDto transferDto) {
        SysAppDevelopTeamMember member = (SysAppDevelopTeamMember)this.appDevelopTeamMemberService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeamMember::getTeamId, (Object)transferDto.getTeamId())).eq(SysAppDevelopTeamMember::getUserId, (Object)transferDto.getTargetUserId()));
        if (member.getMemberType().equals(1)) {
            throw new BaseException("\u76ee\u6807\u7528\u6237\u5df2\u662f\u7ba1\u7406\u5458\uff01");
        }
        member.setMemberType(Integer.valueOf(1));
        boolean update = this.appDevelopTeamMemberService.updateById((Object)member);
        Long userId = BaseSecurityUtil.getUser().getId();
        SysAppDevelopTeamMember teamMember = (SysAppDevelopTeamMember)this.appDevelopTeamMemberService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeamMember::getTeamId, (Object)transferDto.getTeamId())).eq(SysAppDevelopTeamMember::getUserId, (Object)userId));
        teamMember.setMemberType(Integer.valueOf(0));
        boolean update2 = this.appDevelopTeamMemberService.updateById((Object)teamMember);
        this.sysAppOperationLogService.saveAppOperation(transferDto.getAppId());
        return update && update2;
    }
}

