/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.outside.service.impl;

import com.jxdinfo.hussar.application.dto.AppDevelopTeamDto;
import com.jxdinfo.hussar.application.dto.MemberTypeFeignDto;
import com.jxdinfo.hussar.application.dto.TransferMemberTypeDto;
import com.jxdinfo.hussar.application.dto.UpdateMemberTypeDto;
import com.jxdinfo.hussar.application.outside.feign.RemoteAppTeamCallBackService;
import com.jxdinfo.hussar.application.service.IOutsideAppTeamCallBackService;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.cloud.support.feign.dynamic.HussarDynamicFeignClientFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.application.outside.service.impl.outsideAppTeamCallBackServiceImpl")
public class OutsideAppTeamCallBackServiceImpl
implements IOutsideAppTeamCallBackService {
    private static HussarDynamicFeignClientFactory dynamicFeignClientFactory = (HussarDynamicFeignClientFactory)SpringContextHolder.getBean(HussarDynamicFeignClientFactory.class);

    public void saveAppDevelopTeam(AppDevelopTeamDto appDevelopTeamDto, String serviceName, String appType) {
        RemoteAppTeamCallBackService remoteAppTeamCallBackService = this.initRemoteAppCallBackService(serviceName);
        appDevelopTeamDto.setAppType(appType);
        remoteAppTeamCallBackService.saveAppDevelopTeam(appDevelopTeamDto);
    }

    public void updateAppDevelopTeam(AppDevelopTeamDto appDevelopTeamDto, String appType, String serviceName) {
        RemoteAppTeamCallBackService remoteAppTeamCallBackService = this.initRemoteAppCallBackService(serviceName);
        appDevelopTeamDto.setAppType(appType);
        remoteAppTeamCallBackService.updateAppDevelopTeam(appDevelopTeamDto);
    }

    public void updateMember(UpdateMemberTypeDto updateDto, String serviceName, String appType) {
        RemoteAppTeamCallBackService remoteAppTeamCallBackService = this.initRemoteAppCallBackService(serviceName);
        MemberTypeFeignDto feignDto = new MemberTypeFeignDto();
        BeanUtils.copyProperties((Object)updateDto, (Object)feignDto);
        feignDto.setAppType(appType);
        remoteAppTeamCallBackService.updateMember(feignDto);
    }

    public void removeMembers(Long appId, Long userId, String serviceName, String appType) {
        RemoteAppTeamCallBackService remoteAppTeamCallBackService = this.initRemoteAppCallBackService(serviceName);
        remoteAppTeamCallBackService.removeMembers(appId, userId, appType);
    }

    public void transferAdministrator(TransferMemberTypeDto transferDto, String serviceName, String appType) {
        RemoteAppTeamCallBackService remoteAppTeamCallBackService = this.initRemoteAppCallBackService(serviceName);
        MemberTypeFeignDto feignDto = new MemberTypeFeignDto();
        feignDto.setAppId(transferDto.getAppId());
        feignDto.setTeamId(transferDto.getTeamId());
        feignDto.setUserId(transferDto.getTargetUserId());
        feignDto.setAppType(appType);
        remoteAppTeamCallBackService.transferAdministrator(feignDto);
    }

    private RemoteAppTeamCallBackService initRemoteAppCallBackService(String serviceName) {
        return (RemoteAppTeamCallBackService)dynamicFeignClientFactory.getFeignClient(RemoteAppTeamCallBackService.class, serviceName);
    }
}

