/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.appframe.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.jxdinfo.hussar.appframe.service.IHussarAppFormService;
import com.jxdinfo.hussar.appframe.vo.FieldControlVo;
import com.jxdinfo.hussar.appframe.vo.FieldOperateControlVo;
import com.jxdinfo.hussar.appframe.vo.FormFieldsVo;
import com.jxdinfo.hussar.appframe.vo.FormViewSchemaVo;
import com.jxdinfo.hussar.appframe.vo.FormViewVo;
import com.jxdinfo.hussar.appframe.vo.QueryBusinessDataVo;
import com.jxdinfo.hussar.appframe.vo.TableAuthVo;
import com.jxdinfo.hussar.base.portal.application.service.ISysApplicationExternalService;
import com.jxdinfo.hussar.base.portal.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.base.portal.authority.vo.ButtonVo;
import com.jxdinfo.hussar.base.portal.authority.vo.FieldAuthorityVo;
import com.jxdinfo.hussar.base.portal.form.model.SysForm;
import com.jxdinfo.hussar.common.constant.enums.Whether;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.BaseForm;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.DataFilterType;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.FieldControl;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.FieldControlSchema;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.WidgetField;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.canvas.FormCanvasSchemaDTO;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.canvas.staff.StaffScope;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.setting.FieldControlUnitSchema;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.setting.SubmitSchema;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.FormViewSchemaDTO;
import com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.SettingService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActFormAuth;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.service.SysActFormAuthApiService;
import com.jxdinfo.hussar.workflow.manage.engine.service.SysActHandleAuthApiService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.appframe.service.hussarAppFormServiceImpl")
public class HussarAppFormServiceImpl
implements IHussarAppFormService {
    private static Logger logger = LoggerFactory.getLogger(HussarAppFormServiceImpl.class);
    @Resource
    private FormOperateExposedService formOperateExposedService;
    @Resource
    private ISysApplicationExternalService applicationService;
    @Resource
    @Lazy
    private SysActFormAuthApiService actFormAuthApiService;
    @Resource
    private HttpServletRequest request;
    @Resource
    private SettingService settingService;
    @Resource
    @Lazy
    private SysActHandleAuthApiService actHandleAuthApiService;

    public ApiResponse<Boolean> delete(String var1, String var2) throws Exception {
        return this.formOperateExposedService.delete(var1, var2);
    }

    public ApiResponse<Boolean> appClean(String var1, List<String> var2) throws Exception {
        return this.formOperateExposedService.appClean(var1, var2);
    }

    public ApiResponse<Boolean> create(BaseForm var1, String var2) throws Exception {
        return this.formOperateExposedService.create(var1, var2);
    }

    public ApiResponse<List<DataFilterType>> filters(String var1) {
        return this.formOperateExposedService.filters(var1);
    }

    public ApiResponse<FieldControlSchema> fieldControllers(String var1) {
        return this.formOperateExposedService.fieldControllers(var1);
    }

    public ApiResponse<List<WidgetField>> widgets(String var1) throws IOException {
        return this.formOperateExposedService.widgets(var1);
    }

    public ResponseEntity<ApiResponse<Object>> tableQuery(String formId, String viewId, Map<String, Object> params) {
        return this.formOperateExposedService.tableQuery(formId, viewId, params);
    }

    public ResponseEntity<ApiResponse<Object>> formQuery(String formId, String id) {
        return this.formOperateExposedService.formQuery(formId, id);
    }

    public ResponseEntity<ApiResponse<Object>> deleteBatch(String formId, String ids) {
        return this.formOperateExposedService.deleteBatch(formId, ids);
    }

    public ResponseEntity<ApiResponse<Object>> formSave(String formId, Map<String, Object> params) {
        this.assertDisabled(Long.parseLong(formId));
        return this.formOperateExposedService.formSave(formId, params);
    }

    public ResponseEntity<ApiResponse<Object>> flowFormSubmit(String formId, Map<String, Object> params) {
        this.assertDisabled(Long.parseLong(formId));
        return this.formOperateExposedService.flowFormSubmit(formId, params);
    }

    public ResponseEntity<ApiResponse<Object>> flowFormRecall(String formId, Map<String, Object> params) {
        return this.formOperateExposedService.flowFormRecall(formId, params);
    }

    public ResponseEntity<ApiResponse<Object>> initialNodeReject(String formId, Map<String, Object> params) {
        return this.formOperateExposedService.initialNodeReject(formId, params);
    }

    public ResponseEntity<ApiResponse<Object>> prevNodeReject(String formId, Map<String, Object> params) {
        return this.formOperateExposedService.prevNodeReject(formId, params);
    }

    public ResponseEntity<ApiResponse<Object>> taskEntrust(String formId, Map<String, Object> params) {
        return this.formOperateExposedService.taskEntrust(formId, params);
    }

    public ResponseEntity<ApiResponse<Object>> endProcess(String formId, Map<String, Object> params) {
        return this.formOperateExposedService.endProcess(formId, params);
    }

    public FormFieldsVo getCanvas(String formId) {
        FormFieldsVo formFieldsVo = new FormFieldsVo();
        String appId = this.request.getHeader("appId");
        AssertUtil.isNotEmpty((String)appId, (String)"\u8bf7\u6c42\u5934\u4e2dappId\u4e0d\u80fd\u4e3a\u7a7a");
        SysApplicationVo application = this.applicationService.getAppDetailById(Long.valueOf(Long.parseLong(appId)));
        formFieldsVo.setAppInfo(application);
        FormCanvasSchemaDTO formCanvasSchemaDTO = this.formOperateExposedService.getCanvas(formId, appId);
        formFieldsVo.setFieldInfo(formCanvasSchemaDTO);
        return formFieldsVo;
    }

    public FormViewVo getView(String formId) throws Exception {
        FormViewVo formViewVo = new FormViewVo();
        FormViewSchemaDTO formViewSchemaDTO = this.formOperateExposedService.getView(formId);
        List fieldAuthorityVoList = this.applicationService.formAuthorityField(Long.valueOf(Long.parseLong(formId)));
        ArrayList<TableAuthVo> authVoList = new ArrayList<TableAuthVo>();
        if (HussarUtils.isNotEmpty((Object)fieldAuthorityVoList)) {
            for (FieldAuthorityVo item : fieldAuthorityVoList) {
                authVoList.add(new TableAuthVo(item));
            }
        }
        formViewVo.setFieldAuthorityVoList(authVoList);
        List unifyButtonList = this.applicationService.formAuthorityButton(Long.valueOf(Long.parseLong(formId)));
        List buttonCodeList = unifyButtonList.stream().map(ButtonVo::getButtonCode).distinct().collect(Collectors.toList());
        formViewVo.setButtonList(buttonCodeList);
        FormViewSchemaVo formViewSchemaVo = new FormViewSchemaVo();
        if (HussarUtils.isNotEmpty((Object)formViewSchemaDTO)) {
            CopyPropertieUtils.copyProperties((Object)formViewSchemaVo, (Object)formViewSchemaDTO);
            String appId = this.request.getHeader("appId");
            AssertUtil.isNotEmpty((String)appId, (String)"\u8bf7\u6c42\u5934\u4e2dappId\u4e0d\u80fd\u4e3a\u7a7a");
            FormCanvasSchemaDTO canvas = this.formOperateExposedService.getCanvas(formId, appId);
            formViewSchemaVo.setProps(canvas.getProps());
        }
        formViewVo.setFormView(formViewSchemaVo);
        return formViewVo;
    }

    public FieldControlVo getFieldControl(String formId, String taskId, String formType, String processKey) throws IOException {
        BpmResponseResult result;
        FieldControlUnitSchema fieldControlUnitSchema = this.formOperateExposedService.getFieldControl(formId);
        FieldControlVo fieldControlVo = new FieldControlVo();
        if (HussarUtils.isEmpty((Object)fieldControlUnitSchema)) {
            return fieldControlVo;
        }
        fieldControlVo.setFieldControlSchema(fieldControlUnitSchema);
        ArrayList<FieldControl> unifyControlList = new ArrayList<FieldControl>();
        if (HussarUtils.isEmpty((Object)fieldControlUnitSchema.getFieldControl())) {
            return fieldControlVo;
        }
        HashMap<String, FieldControl> unifyFieldControlMap = new HashMap<String, FieldControl>();
        this.initFieldControl(fieldControlUnitSchema.getFieldControl().getAdd(), unifyControlList, unifyFieldControlMap);
        List fieldAuthorityVoList = this.applicationService.formAuthorityField(Long.valueOf(Long.parseLong(formId)));
        ArrayList<String> unifyReadable = new ArrayList<String>();
        ArrayList<String> unifyWriteable = new ArrayList<String>();
        if (HussarUtils.isNotEmpty((Object)fieldAuthorityVoList)) {
            fieldAuthorityVoList.forEach(item -> {
                if (item.getCanRead().equals(Whether.NO.getValue())) {
                    unifyReadable.add(item.getFieldId());
                }
                if (item.getCanWrite().equals(Whether.NO.getValue())) {
                    unifyWriteable.add(item.getFieldId());
                }
            });
            this.changeControlType(unifyReadable, unifyWriteable, new ArrayList<String>(), unifyFieldControlMap);
        }
        fieldControlVo.setUnifyControlList(unifyControlList);
        if (HussarUtils.isNotBlank((CharSequence)formType) && HussarUtils.isNotEmpty((Object)(result = this.actFormAuthApiService.queryFormAuthConfigs(formId, taskId, formType, processKey)).getResult())) {
            List actFormAuthList = (List)JsonUtil.convertValue((Object)result.getResult().getJSONObject(0).get((Object)"data"), (TypeReference)new TypeReference<List<SysActFormAuth>>(){});
            SysActFormAuth actFormAuth = (SysActFormAuth)actFormAuthList.get(0);
            boolean isFirst = true;
            if ("2".equals(formType)) {
                isFirst = (Boolean)result.getResult().getJSONObject(0).get((Object)"isFirst");
            }
            ArrayList<String> bpmInsHidden = new ArrayList<String>();
            ArrayList<String> bpmInsDisabled = new ArrayList<String>();
            ArrayList<String> bpmRequired = new ArrayList<String>();
            if (HussarUtils.isNotBlank((CharSequence)actFormAuth.getInsHidden())) {
                bpmInsHidden.addAll(Arrays.asList(actFormAuth.getInsHidden().substring(1, actFormAuth.getInsHidden().length() - 1).replaceAll("\"", "").split(",")));
            }
            if (HussarUtils.isNotBlank((CharSequence)actFormAuth.getInsRequired())) {
                bpmRequired.addAll(Arrays.asList(actFormAuth.getInsRequired().substring(1, actFormAuth.getInsRequired().length() - 1).replaceAll("\"", "").split(",")));
            }
            if (HussarUtils.isNotBlank((CharSequence)actFormAuth.getInsDisabled())) {
                bpmInsDisabled.addAll(Arrays.asList(actFormAuth.getInsDisabled().substring(1, actFormAuth.getInsDisabled().length() - 1).replaceAll("\"", "").split(",")));
            }
            ArrayList<FieldControl> controlList = new ArrayList<FieldControl>();
            HashMap<String, FieldControl> fieldControlMap = new HashMap<String, FieldControl>();
            this.initFieldControl(fieldControlUnitSchema.getFieldControl().getAdd(), controlList, fieldControlMap);
            if ("2".equals(formType) && !isFirst) {
                ArrayList<String> bpmInsShow = new ArrayList<String>();
                if (HussarUtils.isNotBlank((CharSequence)actFormAuth.getInsShow())) {
                    bpmInsShow.addAll(Arrays.asList(actFormAuth.getInsShow().substring(1, actFormAuth.getInsShow().length() - 1).replaceAll("\"", "").split(",")));
                }
                ArrayList<String> bpmAllFields = new ArrayList<String>();
                bpmAllFields.addAll(bpmInsShow);
                bpmAllFields.addAll(bpmInsHidden);
                ArrayList newFields = new ArrayList(fieldControlMap.keySet());
                newFields.removeAll(bpmAllFields);
                bpmInsDisabled.addAll(newFields);
            }
            this.changeControlType(bpmInsHidden, bpmInsDisabled, bpmRequired, fieldControlMap);
            fieldControlVo.setBpmControl(controlList);
        }
        return fieldControlVo;
    }

    private void changeControlType(List<String> disReadable, List<String> disWriteable, List<String> disRequired, Map<String, FieldControl> fieldControlMap) {
        FieldControl fieldControl;
        for (String fileId : disReadable) {
            fieldControl = fieldControlMap.get(fileId);
            if (!HussarUtils.isNotEmpty((Object)fieldControl)) continue;
            fieldControl.setVisible(false);
            fieldControl.setWitable(false);
        }
        for (String fileId : disWriteable) {
            fieldControl = fieldControlMap.get(fileId);
            if (!HussarUtils.isNotEmpty((Object)fieldControl)) continue;
            fieldControl.setWitable(false);
        }
        for (String fileId : disRequired) {
            fieldControl = fieldControlMap.get(fileId);
            if (!HussarUtils.isNotEmpty((Object)fieldControl)) continue;
            fieldControl.setRequired(true);
        }
    }

    public FieldOperateControlVo getOperateControl(String formId, String taskId, String formType, String processKey) {
        BpmResponseResult result;
        FieldOperateControlVo fieldOperateControlVo = new FieldOperateControlVo();
        List unifyButtonList = this.applicationService.formAuthorityButton(Long.valueOf(Long.parseLong(formId)));
        List buttonCodeList = unifyButtonList.stream().map(ButtonVo::getButtonCode).collect(Collectors.toList());
        fieldOperateControlVo.setUnifyButtonList(buttonCodeList);
        if (HussarUtils.isNotBlank((CharSequence)formType) && HussarUtils.isNotEmpty((Object)(result = this.actHandleAuthApiService.queryHandleAuthConfigs(processKey, taskId, formType)).getResult())) {
            JSONArray actHandleAuth = result.getResult();
            fieldOperateControlVo.setBpmOperateControl(actHandleAuth);
        }
        return fieldOperateControlVo;
    }

    public List<String> getSummary(String formId) {
        FormDesignResponse summary = this.settingService.getSummary(formId);
        if (HussarUtils.isNotEmpty((Object)summary.getData())) {
            return (List)summary.getData();
        }
        return Collections.emptyList();
    }

    public SubmitSchema getSubmit(String formId) {
        return this.formOperateExposedService.getSubmit(formId);
    }

    public ResponseEntity<ApiResponse<Object>> flowDeleteBatch(String formId, String ids) {
        return this.formOperateExposedService.deleteBatch(formId, ids);
    }

    public ApiResponse<QueryBusinessDataVo> queryBusinessData(String formId, String appId) {
        FormCanvasSchemaDTO formCanvasSchemaDTO = this.formOperateExposedService.getCanvas(formId, appId);
        Object data = ((ApiResponse)this.formOperateExposedService.queryBusinessData(formId, appId).getBody()).getData();
        QueryBusinessDataVo result = new QueryBusinessDataVo();
        result.setBusinessData(data);
        result.setWidgetList(formCanvasSchemaDTO.getWidgets());
        return ApiResponse.success((Object)result);
    }

    public ApiResponse<Boolean> saveStaff(StaffScope staffScope) throws JsonProcessingException {
        return this.formOperateExposedService.saveStaff(staffScope);
    }

    public ApiResponse<StaffScope> getStaffScope(String formId, String widgetName) {
        return this.formOperateExposedService.getStaffScope(formId, widgetName);
    }

    private void changeFieldControl(Collection<FieldControl> fieldControlList, Collection<String> readable, Collection<String> writeable) {
        if (HussarUtils.isNotEmpty(fieldControlList)) {
            FieldControl fieldControl;
            ArrayList allFieldIdList = new ArrayList();
            HashMap fieldControlMap = new HashMap();
            fieldControlList.forEach(item -> {
                allFieldIdList.add(item.getField());
                fieldControlMap.put(item.getField(), item);
            });
            Collection unreadable = CollectionUtils.subtract(allFieldIdList, readable);
            Collection unWriteable = CollectionUtils.subtract(allFieldIdList, writeable);
            for (String item2 : unreadable) {
                fieldControl = (FieldControl)fieldControlMap.get(item2);
                fieldControl.setVisible(false);
            }
            for (String item2 : unWriteable) {
                fieldControl = (FieldControl)fieldControlMap.get(item2);
                fieldControl.setWitable(false);
            }
        }
    }

    private List<FieldControl> initFieldControl(List<FieldControl> fieldControlList, List<FieldControl> result, Map<String, FieldControl> relationship) {
        if (HussarUtils.isNotEmpty(fieldControlList)) {
            for (FieldControl fieldControl : fieldControlList) {
                FieldControl newFieldControl = new FieldControl();
                newFieldControl.setField(fieldControl.getField());
                newFieldControl.setTitle(fieldControl.getTitle());
                newFieldControl.setType(fieldControl.getType());
                newFieldControl.setVisible(true);
                newFieldControl.setWitable(true);
                newFieldControl.setRequired(false);
                if (HussarUtils.isNotEmpty((Object)fieldControl.getChildren())) {
                    List<FieldControl> children = this.initFieldControl(fieldControl.getChildren(), new ArrayList<FieldControl>(), relationship);
                    newFieldControl.setChildren(children);
                }
                relationship.put(newFieldControl.getField(), newFieldControl);
                result.add(newFieldControl);
            }
        }
        return result;
    }

    private void assertDisabled(Long formId) {
        SysForm form = this.applicationService.getFormDetailById(formId);
        if (HussarUtils.isNotEmpty((Object)form) && Whether.NO.getValue().equals(form.getFormStatus())) {
            throw new BaseException("\u8868\u5355\u5df2\u88ab\u7981\u7528\uff0c\u65e0\u6cd5\u8fdb\u884c\u8be5\u64cd\u4f5c");
        }
    }
}

