/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.appframe.controller;

import com.jxdinfo.hussar.appframe.module.SysNoCodeConditionInfo;
import com.jxdinfo.hussar.appframe.module.SysNoCodeCustomTable;
import com.jxdinfo.hussar.appframe.service.IHussarAppConditionInfoService;
import com.jxdinfo.hussar.appframe.service.IHussarAppCustomFieldService;
import com.jxdinfo.hussar.appframe.service.IHussarAppFormService;
import com.jxdinfo.hussar.appframe.vo.FieldControlVo;
import com.jxdinfo.hussar.appframe.vo.FieldOperateControlVo;
import com.jxdinfo.hussar.appframe.vo.FormFieldsVo;
import com.jxdinfo.hussar.appframe.vo.FormViewVo;
import com.jxdinfo.hussar.appframe.vo.QueryBusinessDataVo;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.canvas.staff.StaffScope;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.setting.SubmitSchema;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/hussarApp/formInfo"})
public class HussarAppFormController {
    @Resource
    private IHussarAppFormService appFormService;
    @Resource
    private IHussarAppCustomFieldService hussarAppCustomFieldService;
    @Resource
    private IHussarAppConditionInfoService hussarAppConditionInfoService;

    @ApiOperation(value="\u8868\u683c\u89c6\u56fe\u67e5\u8be2", notes="\u8868\u683c\u89c6\u56fe\u67e5\u8be2")
    @PostMapping(value={"/tableQuery"})
    public ResponseEntity<ApiResponse<Object>> tableQuery(@RequestParam String formId, @RequestParam String viewId, @RequestBody Map<String, Object> params) {
        return this.appFormService.tableQuery(formId, viewId, params);
    }

    @ApiOperation(value="\u8868\u5355\u67e5\u8be2", notes="\u8868\u5355\u67e5\u8be2")
    @GetMapping(value={"/formQuery"})
    public ResponseEntity<ApiResponse<Object>> formQuery(@RequestParam String formId, @RequestParam String id, @RequestParam(required=false) String tabType) {
        return this.appFormService.formQuery(formId, id, tabType);
    }

    @ApiOperation(value="\u8868\u683c\u6570\u636e\u6279\u91cf\u5220\u9664", notes="\u8868\u683c\u6570\u636e\u6279\u91cf\u5220\u9664")
    @PostMapping(value={"/deleteBatch"})
    public ResponseEntity<ApiResponse<Object>> deleteBatch(@RequestParam String formId, @RequestParam String ids) {
        return this.appFormService.deleteBatch(formId, ids);
    }

    @ApiOperation(value="\u8868\u5355\u6570\u636e\u4fdd\u5b58", notes="\u8868\u5355\u6570\u636e\u4fdd\u5b58")
    @PostMapping(value={"/formSave"})
    public ResponseEntity<ApiResponse<Object>> formSave(@RequestParam String formId, @RequestBody Map<String, Object> params) {
        return this.appFormService.formSave(formId, params);
    }

    @ApiOperation(value="\u63d0\u4ea4\u6d41\u7a0b", notes="\u63d0\u4ea4\u6d41\u7a0b")
    @PostMapping(value={"/flowFormSubmit"})
    public ResponseEntity<ApiResponse<Object>> flowFormSubmit(@RequestParam String formId, @RequestBody Map<String, Object> params) {
        return this.appFormService.flowFormSubmit(formId, params);
    }

    @ApiOperation(value="\u64a4\u56de\u6d41\u7a0b", notes="\u64a4\u56de\u6d41\u7a0b")
    @PostMapping(value={"/flowFormRecall"})
    public ResponseEntity<ApiResponse<Object>> flowFormRecall(@RequestParam String formId, @RequestBody Map<String, Object> params) {
        return this.appFormService.flowFormRecall(formId, params);
    }

    @ApiOperation(value="\u9a73\u56de\u81f3\u521d\u59cb\u70b9", notes="\u9a73\u56de\u81f3\u521d\u59cb\u70b9")
    @PostMapping(value={"/initialNodeReject"})
    public ResponseEntity<ApiResponse<Object>> initialNodeReject(@RequestParam String formId, @RequestBody Map<String, Object> params) {
        return this.appFormService.initialNodeReject(formId, params);
    }

    @ApiOperation(value="\u9a73\u56de\u81f3\u4e0a\u4e00\u8282\u70b9", notes="\u9a73\u56de\u81f3\u4e0a\u4e00\u8282\u70b9")
    @PostMapping(value={"/prevNodeReject"})
    public ResponseEntity<ApiResponse<Object>> prevNodeReject(@RequestParam String formId, @RequestBody Map<String, Object> params) {
        return this.appFormService.prevNodeReject(formId, params);
    }

    @ApiOperation(value="\u4efb\u52a1\u8f6c\u529e", notes="\u4efb\u52a1\u8f6c\u529e")
    @PostMapping(value={"/taskEntrust"})
    public ResponseEntity<ApiResponse<Object>> taskEntrust(@RequestParam String formId, @RequestBody Map<String, Object> params) {
        return this.appFormService.taskEntrust(formId, params);
    }

    @ApiOperation(value="\u6d41\u7a0b\u7ec8\u6b62", notes="\u6d41\u7a0b\u7ec8\u6b62")
    @PostMapping(value={"/endProcess"})
    public ResponseEntity<ApiResponse<Object>> endProcess(@RequestParam String formId, @RequestBody Map<String, Object> params) {
        return this.appFormService.endProcess(formId, params);
    }

    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u8bbe\u8ba1\u5668\u753b\u5e03", notes="\u83b7\u53d6\u8868\u5355\u8bbe\u8ba1\u5668\u753b\u5e03")
    @GetMapping(value={"/getCanvas"})
    public ApiResponse<FormFieldsVo> getCanvas(@RequestParam String formId) {
        return ApiResponse.success((Object)this.appFormService.getCanvas(formId));
    }

    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u89c6\u56fe", notes="\u83b7\u53d6\u8868\u5355\u89c6\u56fe")
    @GetMapping(value={"/getView"})
    public ApiResponse<FormViewVo> getView(@RequestParam String formId) throws Exception {
        return ApiResponse.success((Object)this.appFormService.getView(formId));
    }

    @ApiOperation(value="\u83b7\u53d6\u5b57\u6bb5\u6743\u9650", notes="\u83b7\u53d6\u5b57\u6bb5\u6743\u9650")
    @GetMapping(value={"/getFieldControl"})
    public ApiResponse<FieldControlVo> getFieldControl(@RequestParam String formId, @RequestParam(required=false) String taskId, @RequestParam(required=false) String bpmFormType, @RequestParam(required=false) String processKey) throws IOException {
        return ApiResponse.success((Object)this.appFormService.getFieldControl(formId, taskId, bpmFormType, processKey));
    }

    @ApiOperation(value="\u83b7\u53d6\u64cd\u4f5c\u6743\u9650", notes="\u83b7\u53d6\u64cd\u4f5c\u6743\u9650")
    @GetMapping(value={"/getOperateControl"})
    public ApiResponse<FieldOperateControlVo> getOperateControl(@RequestParam String formId, @RequestParam(required=false) String taskId, @RequestParam(required=false) String bpmformType, @RequestParam(required=false) String processKey) {
        return ApiResponse.success((Object)this.appFormService.getOperateControl(formId, taskId, bpmformType, processKey));
    }

    @ApiOperation(value="\u83b7\u53d6\u6458\u8981", notes="\u83b7\u53d6\u6458\u8981")
    @GetMapping(value={"/getSummary"})
    public ApiResponse<List<String>> getSummary(@RequestParam String formId) {
        return ApiResponse.success((Object)this.appFormService.getSummary(formId));
    }

    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u63d0\u4ea4\u914d\u7f6e", notes="\u83b7\u53d6\u8868\u5355\u63d0\u4ea4\u914d\u7f6e")
    @GetMapping(value={"/getSubmit"})
    public ApiResponse<SubmitSchema> getSubmit(@RequestParam String formId) {
        return ApiResponse.success((Object)this.appFormService.getSubmit(formId));
    }

    @ApiOperation(value="\u6d41\u7a0b\u8868\u5355\u6279\u91cf\u5220\u9664", notes="\u6d41\u7a0b\u8868\u5355\u6279\u91cf\u5220\u9664")
    @PostMapping(value={"/flowDeleteBatch"})
    public ResponseEntity<ApiResponse<Object>> flowDeleteBatch(@RequestParam String formId, @RequestParam String ids) {
        return this.appFormService.flowDeleteBatch(formId, ids);
    }

    @GetMapping(value={"/queryCustomFieldInfo"})
    @ApiOperation(value="\u83b7\u53d6\u81ea\u5b9a\u4e49\u5e93\u8868\u914d\u7f6e", notes="\u83b7\u53d6\u81ea\u5b9a\u4e49\u5e93\u8868\u914d\u7f6e\u63a5\u53e3")
    public ApiResponse<SysNoCodeCustomTable> queryCustomFieldInfo(@RequestParam String viewId, @RequestParam Long formId) {
        return ApiResponse.success((Object)this.hussarAppCustomFieldService.queryCustomFieldInfo(viewId, formId));
    }

    @PostMapping(value={"/insertOrUpdateCustomFieldInfo"})
    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539\u6570\u636e\u914d\u7f6e", notes="\u65b0\u589e\u6216\u4fee\u6539\u6570\u636e\u914d\u7f6e")
    public ApiResponse<String> addCustomFieldInfo(@RequestBody SysNoCodeCustomTable sysNoCodeCustomTable) {
        return ApiResponse.success((String)this.hussarAppCustomFieldService.insertOrUpdate(sysNoCodeCustomTable));
    }

    @GetMapping(value={"/getQueryInfo"})
    @ApiOperation(value="\u83b7\u53d6\u67e5\u8be2\u6761\u4ef6", notes="\u83b7\u53d6\u67e5\u8be2\u6761\u4ef6")
    public ApiResponse<List<SysNoCodeConditionInfo>> getQueryInfo(@RequestParam String viewId, @RequestParam Long formId) {
        return ApiResponse.success((Object)this.hussarAppConditionInfoService.getQueryInfo(viewId, formId));
    }

    @PostMapping(value={"/insertConditionInfo"})
    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539\u67e5\u8be2\u6761\u4ef6\u6a21\u677f", notes="\u65b0\u589e\u6216\u4fee\u6539\u67e5\u8be2\u6761\u4ef6\u6a21\u677f")
    public ApiResponse<String> insertConditionInfo(@RequestBody SysNoCodeConditionInfo sysNoCodeConditionInfo) {
        return ApiResponse.success((String)this.hussarAppConditionInfoService.insertOrUpdate(sysNoCodeConditionInfo));
    }

    @PostMapping(value={"/updateConditionInfo"})
    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539\u67e5\u8be2\u6761\u4ef6\u6a21\u677f", notes="\u65b0\u589e\u6216\u4fee\u6539\u67e5\u8be2\u6761\u4ef6\u6a21\u677f")
    public ApiResponse<String> UpdateConditionInfo(@RequestBody SysNoCodeConditionInfo sysNoCodeConditionInfo) {
        return ApiResponse.success((String)this.hussarAppConditionInfoService.insertOrUpdate(sysNoCodeConditionInfo));
    }

    @PostMapping(value={"/delConditionInfo"})
    @ApiOperation(value="\u5220\u9664\u67e5\u8be2\u6761\u4ef6\u6a21\u677f", notes="\u5220\u9664\u67e5\u8be2\u6761\u4ef6\u6a21\u677f")
    public ApiResponse<String> delConditionInfo(@RequestBody Long id) {
        return ApiResponse.success((String)this.hussarAppConditionInfoService.del(id));
    }

    @GetMapping(value={"/queryBusinessData"})
    @ApiOperation(value="\u8868\u683c\u67e5\u8be2", notes="\u8868\u683c\u67e5\u8be2")
    public ApiResponse<QueryBusinessDataVo> queryBusinessData(@RequestParam String formId, @RequestParam String appId) {
        return this.appFormService.queryBusinessData(formId, appId);
    }

    @PostMapping(value={"/saveStaffScope"})
    public ApiResponse<Boolean> saveStaffScope(@RequestBody StaffScope staffScope) throws Exception {
        return this.appFormService.saveStaff(staffScope);
    }

    @GetMapping(value={"/getStaffScope"})
    public ApiResponse<StaffScope> getStaffScope(@RequestParam String formId, @RequestParam String widgetName) throws Exception {
        return this.appFormService.getStaffScope(formId, widgetName);
    }
}

