/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.fusion.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.springframework.web.multipart.MultipartFile;

public class OkHttpUtil {
    private static final MediaType JSON_MEDIA_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    private static final OkHttpClient client = new OkHttpClient().newBuilder().connectTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).build();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String sendPost(String url, Map<String, String> headers, Map<String, Object> params) {
        String jsonBody = OkHttpUtil.createJsonBody(params);
        RequestBody requestBody = RequestBody.create((String)jsonBody, (MediaType)JSON_MEDIA_TYPE);
        Request request = OkHttpUtil.buildRequest(url, headers, requestBody);
        try (Response response = client.newCall(request).execute();){
            if (response.isSuccessful() && response.body() != null) {
                String string = Objects.requireNonNull(response.body()).string();
                return string;
            }
            throw new IOException("Request failed: " + response.code() + " - " + response.message());
        }
        catch (IOException e) {
            throw new HussarException("Request error: " + e.getMessage(), (Throwable)e);
        }
    }

    private static Request buildRequest(String url, Map<String, String> headers, RequestBody requestBody) {
        Request.Builder builder = new Request.Builder().url(url).post(requestBody);
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                builder.addHeader(entry.getKey(), entry.getValue());
            }
        }
        return builder.build();
    }

    private static String createJsonBody(Map<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return "{}";
        }
        return JSON.toJSONString(params);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JSONObject multipartFormDataPost(String url, MultipartFile file, Map<String, String> inParams) throws IOException {
        MultipartBody.Builder requestBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        requestBodyBuilder.addFormDataPart("file", file.getOriginalFilename(), RequestBody.create((byte[])file.getBytes(), (MediaType)MediaType.parse((String)"application/octet-stream")));
        inParams.forEach((arg_0, arg_1) -> ((MultipartBody.Builder)requestBodyBuilder).addFormDataPart(arg_0, arg_1));
        MultipartBody requestBody = requestBodyBuilder.build();
        Request request = new Request.Builder().url(url).post((RequestBody)requestBody).build();
        try (Response response = client.newCall(request).execute();){
            if (response.isSuccessful() && response.body() != null) {
                JSONObject jSONObject = JSON.parseObject((String)Objects.requireNonNull(response.body()).string());
                return jSONObject;
            }
            throw new HussarException("Failed to call third-party API: " + response.message());
        }
        catch (IOException e) {
            throw new HussarException("Error calling third-party API", (Throwable)e);
        }
    }
}

