/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.fusion.controller;

import com.jxdinfo.hussar.ai.fusion.dto.QuestionDto;
import com.jxdinfo.hussar.ai.fusion.service.AIModelService;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;

@RestController
@RequestMapping(value={"/ai/code"})
public class AICodeController {
    @Resource
    private AIModelService aiModelService;

    @PostMapping(value={"/generate/flux"})
    public Flux<String> generateCodeFlux(@RequestBody QuestionDto questionDto) {
        return this.aiModelService.conversation(questionDto.forGenerateCode());
    }

    @PostMapping(value={"/optimized"})
    public Flux<String> optimizedCode(@RequestBody QuestionDto questionDto) {
        return this.aiModelService.conversation(questionDto.forOptimizedCode());
    }

    @PostMapping(value={"/interpretive"})
    public Flux<String> interpretiveCode(@RequestBody QuestionDto questionDto) {
        return this.aiModelService.conversation(questionDto.forInterpretiveCode());
    }
}

