/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.fusion.config;

import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import javax.net.ssl.SSLException;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.netty.http.client.HttpClient;

@Configuration
public class WebClientConfig {
    @Bean(name={"webClient"})
    public WebClient getWebClient() {
        return WebClient.create();
    }

    @Bean(name={"ignoreSSLWebClient"})
    public WebClient getIgnoreSSLWebClient() throws SSLException {
        SslContext sslContext = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
        HttpClient httpClient = HttpClient.create().secure(contextSpec -> contextSpec.sslContext(sslContext));
        return WebClient.builder().clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).defaultHeader("Content-Type", new String[]{"application/json"}).build();
    }
}

