/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.fusion.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.ai.fusion.service.AIModelService;
import com.jxdinfo.hussar.ai.fusion.service.impl.BaseAIModelServiceImpl;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"hussar.ai.model.mode"}, havingValue="huawei-ds")
public class HwDsAIModelServiceImpl
extends BaseAIModelServiceImpl
implements AIModelService {
    @Override
    public String getRequestUrl(Map<String, String> params) {
        return params.get("url");
    }

    @Override
    public Map<String, String> initHeader(Map<String, String> params) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", "Bearer " + params.get("api-key"));
        return headers;
    }

    @Override
    public Map<String, Object> initRequestBody(String questionContent, Map<String, String> params, String aiQuestionTemplate, boolean stream) {
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("model", params.get("model"));
        requestBody.put("max_tokens", params.get("max-tokens"));
        requestBody.put("stream", stream);
        requestBody.put("temperature", params.get("temperature"));
        requestBody.put("messages", JSON.parseArray((String)String.format(aiQuestionTemplate, questionContent)));
        return requestBody;
    }
}

