/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.fusion.ocr.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.ai.fusion.ocr.dto.OcrRequest;
import com.jxdinfo.hussar.ai.fusion.ocr.properties.OcrProperties;
import com.jxdinfo.hussar.ai.fusion.ocr.service.OcrService;
import com.jxdinfo.hussar.ai.fusion.util.OkHttpUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
@ConditionalOnProperty(name={"hussar.ai.ocr.mode"}, havingValue="jxd")
public class JxdOcrServiceImpl
implements OcrService {
    @Autowired
    private OcrProperties ocrProperties;

    @Override
    public JSONObject ocrServer(MultipartFile file, OcrRequest ocrRequest) throws IOException {
        Map<String, String> params = this.ocrProperties.getParams();
        String url = params.get("url");
        Map<String, String> inParams = this.handleInParams(ocrRequest);
        return OkHttpUtil.multipartFormDataPost(url, file, inParams);
    }

    private Map<String, String> handleInParams(OcrRequest ocrRequest) {
        String type = ocrRequest.getType();
        HashMap<String, String> inParams = new HashMap<String, String>();
        switch (type) {
            case "common": {
                inParams.put("file_type", ocrRequest.getFileType());
                inParams.put("text", "1");
                inParams.put("rec_type", "print");
                break;
            }
            case "handwriting": {
                inParams.put("file_type", ocrRequest.getFileType());
                inParams.put("text", "1");
                inParams.put("rec_type", "handwriting");
                break;
            }
            case "seal": {
                inParams.put("file_type", ocrRequest.getFileType());
                inParams.put("objdet", "1");
                inParams.put("seal_rec", "1");
                inParams.put("text", "0");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return inParams;
    }
}

