/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.agenda.controller;

import com.jxdinfo.hussar.agenda.model.SysAgenda;
import com.jxdinfo.hussar.agenda.service.ISysAgendaService;
import com.jxdinfo.hussar.agenda.vo.AgendaVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.mp.base.controller.HussarBaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u65e5\u7a0b\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/agendaFront"})
public class SysAgendaFrontController
extends HussarBaseController<SysAgenda, ISysAgendaService> {
    @Resource
    private ISysAgendaService sysAgendaService;

    @ApiOperation(value="\u83b7\u53d6\u67d0\u5929\u65e5\u7a0b\u4fe1\u606f", notes="\u83b7\u53d6\u67d0\u5929\u65e5\u7a0b\u4fe1\u606f")
    @GetMapping(value={"/getAgendaInfo"})
    @AuditLog(moduleName="\u65e5\u7a0b\u7ba1\u7406", eventDesc="\u83b7\u53d6\u67d0\u5929\u65e5\u7a0b\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<AgendaVo>> getAgendaInfo(@ApiParam(value="\u65e5\u7a0bDto") String selectDate) {
        return ApiResponse.success((Object)this.sysAgendaService.getAgendaInfo(selectDate));
    }

    @ApiOperation(value="\u65b0\u589e\u65e5\u7a0b", notes="\u65b0\u589e\u65e5\u7a0b")
    @PostMapping(value={"/addAgenda"})
    @AuditLog(moduleName="\u65e5\u7a0b\u7ba1\u7406", eventDesc="\u65b0\u589e\u65e5\u7a0b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Boolean> addAgenda(@ApiParam(value="\u65e5\u7a0b\u5b9e\u4f53\u7c7b") @RequestBody SysAgenda agenda) {
        return ApiResponse.success((Object)this.sysAgendaService.addAgenda(agenda));
    }

    @ApiOperation(value="\u4fee\u6539\u65e5\u7a0b", notes="\u4fee\u6539\u65e5\u7a0b")
    @PostMapping(value={"/editAgenda"})
    @AuditLog(moduleName="\u65e5\u7a0b\u7ba1\u7406", eventDesc="\u4fee\u6539\u65e5\u7a0b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Boolean> editAgenda(@ApiParam(value="\u65e5\u7a0b\u5b9e\u4f53\u7c7b") @RequestBody SysAgenda agenda) {
        return ApiResponse.success((Object)this.sysAgendaService.editAgenda(agenda));
    }

    @ApiOperation(value="\u5220\u9664\u65e5\u7a0b", notes="\u5220\u9664\u65e5\u7a0b")
    @PostMapping(value={"/deleteAgenda"})
    @AuditLog(moduleName="\u65e5\u7a0b\u7ba1\u7406", eventDesc="\u5220\u9664\u65e5\u7a0b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<Boolean> deleteAgenda(@ApiParam(value="\u65e5\u7a0bid") @RequestBody Long agendaId) {
        return ApiResponse.success((Object)this.sysAgendaService.deleteAgenda(agendaId));
    }

    @ApiOperation(value="\u6309\u6708\u83b7\u53d6\u662f\u5426\u6709\u65e5\u7a0b\u7684\u4fe1\u606f", notes="\u6309\u6708\u83b7\u53d6\u662f\u5426\u6709\u65e5\u7a0b\u7684\u4fe1\u606f")
    @GetMapping(value={"/getMouthAgenda"})
    @AuditLog(moduleName="\u65e5\u7a0b\u7ba1\u7406", eventDesc="\u6309\u6708\u83b7\u53d6\u662f\u5426\u6709\u65e5\u7a0b\u7684\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<String>> getMouthAgenda(@ApiParam(value="\u8981\u67e5\u8be2\u7684\u6708\u4efd") @RequestParam(value="selectMouth") String selectMouth) {
        return ApiResponse.success((Object)this.sysAgendaService.getMouthAgenda(selectMouth));
    }
}

