/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.advanced.components.associativequery.manager;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.advanced.components.associativequery.dto.AssociativeQueryDto;
import com.jxdinfo.hussar.advanced.components.associativequery.manager.AssociativeFieldCacheManager;
import com.jxdinfo.hussar.advanced.components.associativequery.model.AssociativeFieldModel;
import com.jxdinfo.hussar.advanced.components.associativequery.vo.AssociativeQueryVo;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.model.DicType;
import com.jxdinfo.hussar.general.dict.service.ISysDicSingleService;
import com.jxdinfo.hussar.general.dict.service.ISysDicTypeService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AssociativeQueryManager<T> {
    @Autowired
    private ISysDicTypeService sysDicTypeService;
    @Autowired
    private ISysDicSingleService sysDicSingleService;
    @Autowired
    private AssociativeFieldCacheManager<T> associativeFieldCacheManager;
    private final Logger logger = LoggerFactory.getLogger(AssociativeQueryManager.class);

    public void dispose(Class<T> tClass, List<AssociativeQueryVo> associativeQueryVoList, AssociativeQueryDto associativeQueryDto, String keyword) {
        Map<String, AssociativeFieldModel> associativeFieldMap = this.associativeFieldCacheManager.getAssociativeFieldMap(tClass);
        if (HussarUtils.isEmpty(associativeFieldMap.values())) {
            return;
        }
        for (AssociativeFieldModel associativeField : associativeFieldMap.values()) {
            switch (associativeField.getSelectType()) {
                case 1: {
                    this.disposeTextSelect(associativeField, associativeQueryVoList, associativeQueryDto, keyword);
                    break;
                }
                case 2: {
                    this.disposeDictSelect(associativeField, associativeQueryVoList, associativeQueryDto, keyword);
                    break;
                }
            }
        }
    }

    public List<AssociativeQueryVo> disposeCustomList(Class<T> tClass, List<AssociativeQueryVo> associativeQueryVoList, AssociativeQueryDto associativeQueryDto) {
        ArrayList<AssociativeQueryVo> associativeQueryVos = new ArrayList<AssociativeQueryVo>();
        for (AssociativeQueryVo associativeQueryVo : associativeQueryVoList) {
            String dataName = associativeQueryVo.getDataName();
            if (HussarUtils.isBlank((CharSequence)dataName)) continue;
            String label = associativeQueryVo.getOptionName();
            String value = associativeQueryVo.getOptionValue();
            this.disposeCustom(tClass, associativeQueryVos, associativeQueryDto, dataName, label, value);
        }
        return associativeQueryVos;
    }

    public AssociativeQueryVo getKeyWordVo(Class<T> tClass, AssociativeQueryDto associativeQueryDto, String keyScreening) {
        if (HussarUtils.isNotBlank((CharSequence)keyScreening) && HussarUtils.isNotEmpty(associativeQueryDto.getKeywords()) && associativeQueryDto.getKeywords().size() == 1 && HussarUtils.isEmpty(associativeQueryDto.getSelectMap().get(keyScreening))) {
            Object field = null;
            AssociativeFieldModel associativeField = this.associativeFieldCacheManager.getAssociativeFieldMap(tClass).get(keyScreening);
            if (HussarUtils.isNotEmpty((Object)associativeField)) {
                return this.getAssociativeQueryVo(associativeField, associativeQueryDto.getKeywords().get(0), associativeQueryDto.getKeywords().get(0));
            }
        }
        return null;
    }

    public List<AssociativeQueryVo> regroupingList(List<List<AssociativeQueryVo>> lists, AssociativeQueryDto associativeQueryDto, AssociativeQueryVo keyAssociativeQueryVo) {
        ArrayList<AssociativeQueryVo> associativeQueryVoList = new ArrayList<AssociativeQueryVo>();
        if (associativeQueryDto.getKeywords().size() == 1 && HussarUtils.isNotEmpty((Object)keyAssociativeQueryVo)) {
            associativeQueryVoList.add(keyAssociativeQueryVo);
        }
        if (HussarUtils.isEmpty(lists = lists.stream().filter(CollectionUtil::isNotEmpty).collect(Collectors.toList()))) {
            return associativeQueryVoList;
        }
        if (lists.size() == 1) {
            associativeQueryVoList.addAll((Collection<AssociativeQueryVo>)lists.get(0));
            return associativeQueryVoList;
        }
        List<List<AssociativeQueryVo>> combinationResults = lists.get(0).stream().map(xva$0 -> Arrays.asList(xva$0)).collect(Collectors.toList());
        combinationResults = this.combinationArray(combinationResults, lists, 1);
        return combinationResults.stream().map(combinationArr -> {
            AssociativeQueryVo associativeQueryVo = new AssociativeQueryVo();
            associativeQueryVo.setLabelName("alllist");
            associativeQueryVo.setAssociativeQueryVo((List<AssociativeQueryVo>)combinationArr);
            return associativeQueryVo;
        }).collect(Collectors.toList());
    }

    private List<List<AssociativeQueryVo>> combinationArray(List<List<AssociativeQueryVo>> combinationResults, List<List<AssociativeQueryVo>> lists, int i) {
        ArrayList<List<AssociativeQueryVo>> res = new ArrayList<List<AssociativeQueryVo>>();
        lists.get(i).forEach(associativeQueryVo -> combinationResults.forEach(associativeQueryVos -> {
            ArrayList<AssociativeQueryVo> combinateArr = new ArrayList<AssociativeQueryVo>((Collection<AssociativeQueryVo>)associativeQueryVos);
            combinateArr.add((AssociativeQueryVo)associativeQueryVo);
            res.add(combinateArr);
        }));
        if (i < lists.size() - 1) {
            return this.combinationArray(res, lists, i + 1);
        }
        return res;
    }

    public void disposeCustom(Class<T> tClass, List<AssociativeQueryVo> associativeQueryVoList, AssociativeQueryDto associativeQueryDto, String fieldName, String label, String value) {
        List<String> valueList = associativeQueryDto.getSelectMap().get(fieldName);
        if (valueList == null) {
            valueList = new ArrayList<String>();
        }
        for (String selectValue : valueList) {
            if (!HussarUtils.equals((Object)selectValue, (Object)value)) continue;
            return;
        }
        AssociativeFieldModel associativeField = this.associativeFieldCacheManager.getAssociativeFieldMap(tClass).get(fieldName);
        if (HussarUtils.isEmpty((Object)associativeField)) {
            return;
        }
        if (!associativeField.isMultiOption() && HussarUtils.isNotEmpty(valueList)) {
            return;
        }
        associativeQueryVoList.add(this.getAssociativeQueryVo(associativeField, label, value));
        valueList.add(value);
        associativeQueryDto.getSelectMap().put(associativeField.getDataName(), valueList);
    }

    public void disposeTextSelect(AssociativeFieldModel associativeField, List<AssociativeQueryVo> associativeQueryVoList, AssociativeQueryDto associativeQueryDto, String key) {
        List<String> selects = associativeQueryDto.getSelectMap().get(associativeField.getDataName());
        if (selects == null) {
            selects = new ArrayList<String>();
        }
        if (!associativeField.isMultiOption() && HussarUtils.isNotEmpty(selects)) {
            return;
        }
        associativeQueryVoList.add(this.getAssociativeQueryVo(associativeField, key, key));
        selects.add(key);
        associativeQueryDto.getSelectMap().put(associativeField.getDataName(), selects);
    }

    public void disposeDictSelect(AssociativeFieldModel associativeField, List<AssociativeQueryVo> associativeQueryVoList, AssociativeQueryDto associativeQueryDto, String key) {
        List<DicVo> dicVoList;
        List<String> dictVlueList = associativeQueryDto.getSelectMap().get(associativeField.getDataName());
        if (dictVlueList == null) {
            dictVlueList = new ArrayList<String>();
        }
        if (ToolUtil.isNotEmpty(dicVoList = this.getDicValue(associativeField.getDictTypeName(), key, dictVlueList))) {
            for (DicVo dicVo : dicVoList) {
                String label = dicVo.getLabel();
                String value = dicVo.getValue();
                AssociativeQueryVo associativeQueryVo = this.getAssociativeQueryVo(associativeField, label, value);
                associativeQueryVoList.add(associativeQueryVo);
                dictVlueList.add(value);
            }
        }
        associativeQueryDto.getSelectMap().put(associativeField.getDataName(), dictVlueList);
    }

    public List<DicVo> getDicValue(String dictTypeName, String keyword, List<String> list) {
        ArrayList<DicVo> dicVos = new ArrayList<DicVo>();
        LambdaQueryWrapper dicTypeWrapper = new LambdaQueryWrapper();
        dicTypeWrapper.eq(DicType::getTypeName, (Object)dictTypeName);
        List dicTypeList = this.sysDicTypeService.list((Wrapper)dicTypeWrapper);
        if (ToolUtil.isNotEmpty((Object)dicTypeList)) {
            DicType dicType = (DicType)dicTypeList.get(0);
            Long id = dicType.getId();
            LambdaQueryWrapper dicSingleWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)dicSingleWrapper.eq(DicSingle::getTypeId, (Object)id)).like(DicSingle::getLabel, (Object)keyword);
            if (ToolUtil.isNotEmpty(list)) {
                dicSingleWrapper.notIn(DicSingle::getValue, list);
            }
            List dicSingleList = this.sysDicSingleService.list((Wrapper)dicSingleWrapper);
            for (DicSingle dicSingle : dicSingleList) {
                DicVo dicVo = new DicVo();
                dicVo.setValue(dicSingle.getValue());
                dicVo.setLabel(dicSingle.getLabel());
                dicVos.add(dicVo);
            }
        }
        return dicVos;
    }

    public AssociativeQueryVo getAssociativeQueryVo(AssociativeFieldModel associativeField, String name, String value) {
        AssociativeQueryVo associativeQueryVo = new AssociativeQueryVo();
        String labelName = associativeField.getLabelName() + "\uff1a";
        associativeQueryVo.setLabelName(labelName);
        associativeQueryVo.setDataName(associativeField.getDataName());
        associativeQueryVo.setMultiOption(associativeField.isMultiOption());
        associativeQueryVo.setTips(labelName + name);
        associativeQueryVo.setOptionName(name);
        associativeQueryVo.setOptionValue(value);
        return associativeQueryVo;
    }
}

