/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.advanced.components.associativequery.manager;

import com.jxdinfo.hussar.advanced.components.associativequery.model.AssociativeFieldModel;
import com.jxdinfo.hussar.advanced.components.associativequery.note.AssociativeField;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

@Component
public class AssociativeFieldCacheManager<T> {
    @Cacheable(value={"AssociativeField"}, key="#tClass.name")
    public Map<String, AssociativeFieldModel> getAssociativeFieldMap(Class<T> tClass) {
        Field[] fields;
        HashMap<String, AssociativeFieldModel> associativeFieldMap = new HashMap<String, AssociativeFieldModel>();
        for (Field field : fields = tClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(AssociativeField.class)) continue;
            AssociativeField associativeField = field.getAnnotation(AssociativeField.class);
            AssociativeFieldModel associativeFieldModel = new AssociativeFieldModel(associativeField.labelName(), associativeField.dataName(), associativeField.dictTypeName(), associativeField.multiOption(), associativeField.selectType());
            associativeFieldMap.put(field.getName(), associativeFieldModel);
        }
        return associativeFieldMap;
    }
}

