/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mobileui.vistor;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSConditionAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSFieldAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSModelAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodePrefix;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodeSuffix;
import com.jxdinfo.hussar.formdesign.base.common.constant.DataConfigConstant;
import com.jxdinfo.hussar.formdesign.base.common.utils.EventUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.QueryAttrUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.RenderVModelUtil;
import com.jxdinfo.hussar.formdesign.codegenerator.core.action.Trigger;
import com.jxdinfo.hussar.formdesign.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.hussar.formdesign.codegenerator.core.component.visitor.VoidVisitor;
import com.jxdinfo.hussar.formdesign.codegenerator.core.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DropDownVoidVisitor
implements VoidVisitor {
    private FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);

    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        this.renderParamsAndData(lcdpComponent, ctx);
        lcdpComponent.registerTemplatePath("/template/mobileui/vant/dropdown/drop_down.ftl");
        this.renderVModel(lcdpComponent, ctx);
        this.removeTrigger(lcdpComponent, ctx);
        this.renderMenuItemLoad(lcdpComponent, ctx);
    }

    private void renderParamsAndData(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        Object hidden;
        Object closeOnClickOutside;
        Object closeOnClickOverlay;
        Object overlay;
        String id = lcdpComponent.getInstanceKey();
        lcdpComponent.addRenderParam("id", (Object)id);
        Map props = lcdpComponent.getProps();
        Object direction = props.get("direction");
        if (ToolUtil.isNotEmpty(direction) && "up".equals(direction.toString())) {
            lcdpComponent.addRenderParam("direction", (Object)"up");
        }
        if (ToolUtil.isNotEmpty(overlay = props.get("overlay")) && "false".equals(overlay.toString())) {
            lcdpComponent.addRenderParam("overlay", (Object)false);
        }
        if (ToolUtil.isNotEmpty(closeOnClickOverlay = props.get("closeOnClickOverlay")) && "false".equals(closeOnClickOverlay.toString())) {
            lcdpComponent.addRenderParam("closeOnClickOverlay", (Object)false);
        }
        if (ToolUtil.isNotEmpty(closeOnClickOutside = props.get("closeOnClickOutside")) && "false".equals(closeOnClickOutside.toString())) {
            lcdpComponent.addRenderParam("closeOnClickOutside", (Object)false);
        }
        if ((hidden = props.get("hidden")) == null) {
            hidden = false;
        }
        lcdpComponent.addRenderParam("hidden", (Object)"hidden");
        ctx.addData(id + "Hidden: " + hidden.toString() + ",");
        Object disabled = props.get("disabled");
        if (disabled == null) {
            disabled = false;
        }
        lcdpComponent.addRenderParam("disabled", (Object)"disabled");
        ctx.addData(id + "Disabled: " + disabled.toString() + ",");
        Object options = props.get("options");
        String defaultValue = "";
        defaultValue = ToolUtil.isNotEmpty(options) ? options.toString() : "[]";
        ArrayList<String> list = new ArrayList<String>();
        list.add("data");
        String optionStringName = RenderVModelUtil.renderDataItemDataOrComputed((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)"DropDownMenuOptions", list, (String)defaultValue);
        lcdpComponent.addRenderParam("optionStringName", (Object)optionStringName);
    }

    private void renderVModel(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        Object defalutValue = lcdpComponent.getProps().get("defaultValue");
        String value = "";
        if (ToolUtil.isNotEmpty(defalutValue) && !"".equals(defalutValue.toString())) {
            value = "'" + defalutValue.toString() + "'";
        }
        String valueData = RenderVModelUtil.renderDataItemDataOrComputed((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)CodeSuffix._DATA.getType(), null, (String)value);
        lcdpComponent.addRenderParam("bindData", (Object)valueData);
    }

    private void renderMenuItemLoad(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        DataSAnalysis dataSAnalysis = (DataSAnalysis)JSONObject.parseObject((String)JSONObject.toJSONString((Object)lcdpComponent.getDatas()), DataSAnalysis.class);
        DataSModelAnalysis dataSModelAnalysis = dataSAnalysis.getDatamodel();
        if (ToolUtil.isNotEmpty((Object)dataSModelAnalysis)) {
            if (dataSModelAnalysis.getType().equals("DataModel")) {
                DataSConditionAnalysis dataSConditionAnalysis = dataSModelAnalysis.getCondition();
                Map dataSFieldAnalysisMap = dataSModelAnalysis.getFields();
                String labelField = "";
                String valueField = "";
                if (ToolUtil.isNotEmpty((Object)dataSFieldAnalysisMap)) {
                    for (Map.Entry fieldList : dataSFieldAnalysisMap.entrySet()) {
                        List fieldAnalyses = (List)fieldList.getValue();
                        for (DataSFieldAnalysis dataSFieldAnalysis : fieldAnalyses) {
                            List dataItemPath = dataSFieldAnalysis.getDataItemPath();
                            if (ToolUtil.isNotEmpty((Object)dataItemPath) && "text".equals(dataItemPath.get(dataItemPath.size() - 1))) {
                                labelField = dataSFieldAnalysis.getFieldName();
                            }
                            if (!ToolUtil.isNotEmpty((Object)dataItemPath) || !"value".equals(dataItemPath.get(dataItemPath.size() - 1))) continue;
                            valueField = dataSFieldAnalysis.getFieldName();
                        }
                    }
                }
                if (ToolUtil.isNotEmpty((Object)labelField) && ToolUtil.isNotEmpty((Object)valueField)) {
                    String querySelectionName;
                    List conditionList;
                    HashMap<String, CharSequence> selectMap = new HashMap<String, CharSequence>();
                    String operationName = "hussarQuery";
                    String dataSelectId = lcdpComponent.getInstanceKey();
                    String apiFileName = "";
                    String apiFilePath = "";
                    String dataModelId = dataSModelAnalysis.getDataModelId();
                    if (ToolUtil.isNotEmpty((Object)dataModelId)) {
                        apiFileName = this.fileMappingService.getFileName(dataModelId);
                        apiFilePath = this.fileMappingService.getMobileImportPath(dataModelId);
                    }
                    if (ToolUtil.isNotEmpty((Object)dataSConditionAnalysis) && ToolUtil.isNotEmpty((Object)(conditionList = dataSConditionAnalysis.getQueryConditionModelList()))) {
                        selectMap.put("queryAttr", QueryAttrUtil.getQueryAttr((List)conditionList, (Ctx)ctx));
                        selectMap.put("queryCheck", QueryAttrUtil.getQueryCheck((List)conditionList, (String)apiFileName).toString());
                    }
                    if (ToolUtil.isNotEmpty((Object)(querySelectionName = dataSConditionAnalysis.getSelectCondition()))) {
                        operationName = operationName + querySelectionName;
                    }
                    if (ToolUtil.isNotEmpty((Object)apiFilePath)) {
                        EventUtil.addCtxImport((Ctx)ctx, (String)apiFileName, (String)apiFilePath);
                    }
                    selectMap.put("importName", apiFileName);
                    selectMap.put("importMethod", operationName);
                    selectMap.put("id", dataSelectId);
                    selectMap.put("text", labelField);
                    selectMap.put("value", valueField);
                    selectMap.putAll(lcdpComponent.getRenderParamsToBind());
                    ctx.addMethod(dataSelectId + "DropDownMenuOptionLoad", RenderUtil.renderTemplate((String)"/template/mobileui/vant/dropdown/drop_down_menu_item_load.ftl", selectMap));
                    ctx.addMounted(CodePrefix._SELF.getType() + dataSelectId + "DropDownMenuOptionLoad();");
                }
            } else if (dataSModelAnalysis.getType().equals("CommonModel")) {
                String apiFileName = "";
                String apiFilePath = "";
                String dataModelId = dataSModelAnalysis.getDataModelId();
                if (ToolUtil.isNotEmpty((Object)dataModelId)) {
                    apiFileName = this.fileMappingService.getFileName(dataModelId);
                    apiFilePath = this.fileMappingService.getMobileImportPath(dataModelId);
                }
                if (ToolUtil.isNotEmpty((Object)apiFilePath)) {
                    EventUtil.addCtxImport((Ctx)ctx, (String)apiFileName, (String)apiFilePath);
                }
                HashMap<String, String> selectMap = new HashMap<String, String>();
                selectMap.put("importName", apiFileName);
                selectMap.put("importMethod", DataConfigConstant.CommonModelCategory.DICT.getImportMethod());
                selectMap.put("instanceKey", lcdpComponent.getInstanceKey());
                selectMap.put("dictType", dataSModelAnalysis.getDictType());
                ctx.addMethod(lcdpComponent.getInstanceKey() + "DropDownMenuOptionLoad", RenderUtil.renderTemplate((String)"/template/mobileui/vant/dropdown/menu_item_load_from_dict.ftl", selectMap));
                ctx.addMounted(CodePrefix._THIS.getType() + lcdpComponent.getInstanceKey() + "DropDownMenuOptionLoad();");
            }
        }
    }

    private void removeTrigger(LcdpComponent lcdpComponent, Ctx ctx) {
        List triggers = lcdpComponent.getTrigger();
        if (ToolUtil.isNotEmpty((Object)triggers)) {
            for (Trigger trigger : triggers) {
                if (!"change".equals(trigger.getName())) continue;
                lcdpComponent.addRenderParam("change", (Object)true);
            }
            triggers.clear();
        }
    }
}

