/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mobileui.provide;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.form.FormColsAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.table.TableOptColsAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodePrefix;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodeSuffix;
import com.jxdinfo.hussar.formdesign.base.common.utils.ComponentDataUtil;
import com.jxdinfo.hussar.formdesign.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.hussar.formdesign.codegenerator.core.component.visitor.ValueVisitor;
import com.jxdinfo.hussar.formdesign.codegenerator.core.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.codegenerator.core.model.ComponentData;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.mobileui.JXDMobileCheckedList.value")
public class CheckedListValueProvide
implements ValueVisitor {
    private LcdpComponent lcdpComponent;
    private Map<String, Object> params;
    private Ctx ctx;

    public void visit(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> params) throws LcdpException {
        this.lcdpComponent = lcdpComponent;
        this.params = params;
        this.ctx = ctx;
    }

    public ComponentData getDataItemValue(List<String> dataItems) throws LcdpException {
        ComponentData data = new ComponentData();
        if (ToolUtil.isNotEmpty(dataItems)) {
            String dataItem;
            switch (dataItem = dataItems.get(0)) {
                case "page": {
                    this.getPageData(dataItems, data);
                    break;
                }
                case "total": {
                    data.setDataType(ComponentData.DataTypeEnum.INTEGER);
                    data.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._TABLE_TOTAL.getType(), dataItems));
                    break;
                }
                case "value": {
                    this.getCheckedData(dataItems, data, dataItem);
                    break;
                }
                case "item": {
                    this.getSelectAndTableData(dataItems, data, dataItem);
                    break;
                }
                case "checked": {
                    this.getCheckedData(dataItems, data, dataItem);
                    break;
                }
            }
        } else {
            data.setDataType(ComponentData.DataTypeEnum.ARRAY_OBJECT);
            ArrayList<String> currDataItem = new ArrayList<String>();
            currDataItem.add("item");
            data.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)"ListData", currDataItem));
        }
        return data;
    }

    public List<ComponentData> getClearValue(List<String> list) throws LcdpException {
        return null;
    }

    private void getPageData(List<String> dataItems, ComponentData data) throws LcdpException {
        ArrayList<String> pageDataItem = new ArrayList<String>();
        pageDataItem.add("page");
        String pageValue = ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)"page", pageDataItem);
        if (dataItems.size() == 2) {
            data.setDataType(ComponentData.DataTypeEnum.INTEGER);
            data.setDataItemSource(ComponentData.DataItemSourceEnum.DATA);
            if ("current".equals(dataItems.get(1))) {
                data.setRenderValue(pageValue + ".current");
            } else if ("size".equals(dataItems.get(1))) {
                data.setRenderValue(pageValue + ".size");
            } else if ("total".equals(dataItems.get(1))) {
                data.setRenderValue(pageValue + ".total");
            }
        } else {
            data.setDataType(ComponentData.DataTypeEnum.OBJECT);
            data.setDataItemSource(ComponentData.DataItemSourceEnum.DATA);
            data.setRenderValue(pageValue);
        }
    }

    private void getSelectAndTableData(List<String> dataItems, ComponentData data, String dataItem) throws LcdpException {
        data.setDataItemSource(ComponentData.DataItemSourceEnum.DATA);
        ArrayList<String> currDataItem = new ArrayList<String>();
        currDataItem.add("item");
        String dataValue = ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)"item", currDataItem);
        if (dataItems.size() == 2) {
            data.setDataType(ComponentData.DataTypeEnum.ARRAY_PRIMARY);
            JSONArray cols = (JSONArray)this.lcdpComponent.getProps().get("component_cols");
            for (Object col : cols) {
                JSONObject colObj = (JSONObject)col;
                if (!colObj.getString("id").equals(dataItems.get(1))) continue;
                data.setRenderValue(dataValue + "." + colObj.getString("field"));
                data.setDataType(((JSONObject)col).getString("dataType"));
            }
        } else {
            data.setDataType(ComponentData.DataTypeEnum.ARRAY_OBJECT);
            data.setRenderValue(dataValue);
        }
    }

    private void getCheckedData(List<String> dataItems, ComponentData data, String dataItem) throws LcdpException {
        String dataValue;
        data.setDataItemSource(ComponentData.DataItemSourceEnum.DATA);
        ArrayList<String> currDataItem = new ArrayList<String>();
        if (dataItem.equals("checked")) {
            currDataItem.add("checked");
            dataValue = ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)"Checked", currDataItem);
        } else {
            currDataItem.add("value");
            dataValue = ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)"ListData", currDataItem);
        }
        String checkDataType = ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)"CheckDataType", currDataItem);
        if (dataItems.size() == 2) {
            data.setDataType(ComponentData.DataTypeEnum.ARRAY_PRIMARY);
            JSONArray cols = (JSONArray)this.lcdpComponent.getProps().get("component_cols");
            for (Object col : cols) {
                JSONObject colObj = (JSONObject)col;
                if (!colObj.getString("id").equals(dataItems.get(1))) continue;
                data.setRenderValue("function(){\nlet result = [];\nif(" + dataValue + ".length){\nif(" + checkDataType + "==='list'){" + dataValue + ".forEach((item) => result.push(item." + colObj.getString("field") + "));}else{" + dataValue + ".forEach((item,index) => {result += item." + colObj.getString("field") + ";\nif(index !== " + dataValue + ".length - 1){result += ','}});}}else{\nresult = " + dataValue + "." + colObj.getString("field") + "}return result;}()");
                data.setDataType(((JSONObject)col).getString("dataType"));
            }
        } else {
            data.setDataType(ComponentData.DataTypeEnum.ARRAY_OBJECT);
            data.setRenderValue(dataValue);
        }
    }

    private void getOptColData(List<String> dataItems, ComponentData data, String dataValue, JSONArray cols) {
        if (ToolUtil.isNotEmpty((Object)cols)) {
            List colsList = cols.toJavaList(TableOptColsAnalysis.class);
            for (TableOptColsAnalysis col : colsList) {
                if (!col.getId().equals(dataItems.get(1))) continue;
                data.setDataItemSource(ComponentData.DataItemSourceEnum.READONLY);
                if (col.getRowSummary() && ToolUtil.isNotEmpty((Object)col.getRowCalculate())) {
                    data.setRenderValue("function(){\nlet result = [];" + dataValue + ".forEach((row) => result.push(" + col.getRowCalculate().getEditFormulaReplace() + "));return result;}()");
                    break;
                }
                data.setRenderValue("function(){\nlet result = [];" + dataValue + ".forEach((item) => result.push(item." + col.getField() + "));return result;}()");
                break;
            }
        }
    }

    public String setValue(List<String> dataItems) {
        return this.getThisPrefix() + this.lcdpComponent.getInstanceKey() + CodeSuffix._LIST_ITEM_DATA.getType();
    }

    public Map<String, String> getComponentColMapping() {
        JSONArray cols = (JSONArray)this.lcdpComponent.getProps().get("component_cols");
        List formColsList = cols.toJavaList(FormColsAnalysis.class);
        HashMap<String, String> map = new HashMap<String, String>(16);
        formColsList.forEach(col -> map.put(col.getId(), col.getField()));
        return map;
    }

    private String getThisPrefix() {
        String thisPrefix = CodePrefix._THIS.getType();
        if (ToolUtil.isNotEmpty(this.params) && ToolUtil.isNotEmpty((Object)this.params.get(CodePrefix.SELF.getType()))) {
            thisPrefix = CodePrefix._SELF.getType();
        }
        return thisPrefix;
    }

    public String getDefaultValue() {
        return "''";
    }
}

