if (fileStr == null || fileStr == "") {
    return "";
}
let arr = fileStr.split(',');
let fileList = [];
Array.from(arr, fileId => {
    hussarRequest.postJson('/attachment/uploadFileQuery', {"fileId":fileId}).then(res => {
        if(res.success) {
            let prefix = res.data.fileName.substring(res.data.fileName.lastIndexOf(".") + 1);
            if(['png', 'jpg', 'jpeg', 'bmp', 'gif', 'webp', 'psd', 'svg', 'tiff'].indexOf(prefix.toLowerCase()) !== -1) {
                fileList.push({url: process.env.VUE_APP_HUSSAR_DEFAULT_API + '/attachment/fileDownload?fileId=' + fileId, isImage: true, id: fileId, fileName: res.data.fileName, fileSize: (res.data.fileSize / 1024).toFixed(2)});
            } else {
                fileList.push({url: res.data.fileName, id: fileId, fileName: res.data.fileName, fileSize: (res.data.fileSize / 1024).toFixed(2)});
            }
        } else {
            self.$toast(res || "文件数据请求错误")
        }
    }).catch((res) => {
        self.$toast(res || "文件数据请求异常");
    })
})
return fileList;
