/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.mobileui.vistor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.speedcode.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.hussar.speedcode.codegenerator.core.component.visitor.VoidVisitor;
import com.jxdinfo.hussar.speedcode.codegenerator.core.ctx.Ctx;
import com.jxdinfo.hussar.speedcode.codegenerator.core.data.model.ComponentReference;
import com.jxdinfo.hussar.speedcode.codegenerator.core.model.ComponentData;
import com.jxdinfo.hussar.speedcode.codegenerator.core.util.DataConfigUtil;
import com.jxdinfo.hussar.speedcode.codegenerator.core.util.DynDataUtil;
import com.jxdinfo.hussar.speedcode.common.exception.LcdpException;
import com.jxdinfo.hussar.speedcode.common.file.FileMappingService;
import com.jxdinfo.hussar.speedcode.common.util.RenderUtil;
import com.jxdinfo.hussar.speedcode.common.util.SpringUtil;
import com.jxdinfo.hussar.speedcode.common.util.ToolUtil;
import com.jxdinfo.speedcode.mobileui.utils.DealVantDataUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class TabVoidVisitor
implements VoidVisitor {
    private FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);

    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        lcdpComponent.registerTemplatePath("template/mobileui/vant/tab/vant_tab.ftl");
        this.renderAttrs(lcdpComponent, ctx);
        this.renderParms(lcdpComponent, ctx);
        this.renderMethod(lcdpComponent, ctx);
        this.renderData(lcdpComponent, ctx);
        this.judgeHorizontalAndVerticalFill(lcdpComponent, ctx);
    }

    private void renderAttrs(LcdpComponent lcdpComponent, Ctx ctx) {
        Object swipeThreshold;
        Object lazyRender;
        Object swipeable;
        Object ellipsis;
        Object animated;
        lcdpComponent.addAttr("ref", lcdpComponent.getInstanceKey() + "Ref");
        DealVantDataUtil dealVantDataUtil = new DealVantDataUtil();
        dealVantDataUtil.dealInstanceAttr(lcdpComponent, ctx);
        Map props = lcdpComponent.getProps();
        Object type = props.get("type");
        if (ToolUtil.isNotEmpty(type) && "card".equals(type.toString())) {
            lcdpComponent.addAttr("type", type.toString());
        }
        if (ToolUtil.isNotEmpty(animated = props.get("animated")) && "true".equals(animated.toString())) {
            lcdpComponent.addAttr("animated", animated.toString());
            Object duration = props.get("duration");
            if (ToolUtil.isNotEmpty(duration) && !"0.3".equals(duration.toString())) {
                lcdpComponent.addAttr("duration", duration.toString());
            }
        }
        if (ToolUtil.isNotEmpty(ellipsis = props.get("ellipsis")) && "false".equals(ellipsis.toString())) {
            lcdpComponent.addAttr("ellipsis", ellipsis.toString());
        }
        if (ToolUtil.isNotEmpty(swipeable = props.get("swipeable")) && "true".equals(swipeable.toString())) {
            lcdpComponent.addAttr("swipeable", swipeable.toString());
        }
        if (ToolUtil.isNotEmpty(lazyRender = props.get("lazyRender")) && "true".equals(lazyRender.toString())) {
            lcdpComponent.addAttr("lazy-render", lazyRender.toString());
        }
        if (ToolUtil.isNotEmpty(swipeThreshold = props.get("swipeThreshold")) && !"5".equals(swipeThreshold.toString())) {
            lcdpComponent.addAttr("swipe-threshold", swipeThreshold.toString());
        }
    }

    private void renderParms(LcdpComponent lcdpComponent, Ctx ctx) {
        Map props = lcdpComponent.getProps();
        String key = lcdpComponent.getInstanceKey();
        lcdpComponent.addRenderParam("id", (Object)key);
        if (ToolUtil.isNotEmpty(props.get("defaultActiveTab"))) {
            lcdpComponent.addRenderParam("bindData", (Object)(key + "Data"));
            ctx.addData(key + "Data:'" + props.get("defaultActiveTab") + "',");
        }
        if (ToolUtil.isNotEmpty(props.get("isIcon")) && "true".equals(props.get("isIcon").toString()) && ToolUtil.isNotEmpty(props.get("iconPosition"))) {
            if ("left".equals(props.get("iconPosition").toString())) {
                lcdpComponent.addRenderParam("iconPositionLeft", (Object)props.get("iconPosition").toString());
            } else if ("right".equals(props.get("iconPosition").toString())) {
                lcdpComponent.addRenderParam("iconPositionRight", (Object)props.get("iconPosition").toString());
            }
        }
    }

    private void renderMethod(LcdpComponent lcdpComponent, Ctx ctx) {
        ctx.addComputed("url", "return window.location.origin + '/#';");
    }

    private void renderData(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        List tabList = JSON.parseArray((String)lcdpComponent.getProps().get("tabList").toString(), HashMap.class);
        JSONObject fromComponentParams = JSON.parseObject((String)String.valueOf(lcdpComponent.getProps().get("formComponentParams")));
        ArrayList formComponentParamList = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)fromComponentParams)) {
            for (Map.Entry entry : fromComponentParams.entrySet()) {
                HashMap fromComponentParam = new HashMap();
                fromComponentParam.put(entry.getKey(), entry.getValue());
                formComponentParamList.add(fromComponentParam);
            }
        }
        int index = 0;
        for (HashMap tab : tabList) {
            String routePath = "";
            if (ToolUtil.isNotEmpty(tab.get("outLink")) && !"".equals(tab.get("outLink"))) {
                routePath = tab.get("outLink").toString();
                tab.put("outLink", routePath);
                continue;
            }
            if (!ToolUtil.isNotEmpty(tab.get("url")) || "".equals(tab.get("url").toString())) continue;
            StringBuilder props = new StringBuilder();
            StringBuilder triggers = new StringBuilder();
            JSONObject pageParamConfig = (JSONObject)((HashMap)JSON.parseObject((String)tab.get("url").toString(), HashMap.class)).get("pageParamConfig");
            String id = ((HashMap)JSON.parseObject((String)tab.get("url").toString(), HashMap.class)).get("fileId").toString();
            routePath = this.fileMappingService.getFormatPath(id);
            String pageName = routePath.substring(routePath.lastIndexOf(47) + 1);
            List events = lcdpComponent.getEvents();
            for (Object entry : events) {
                String eventName = entry.getTrigger();
                String oldName = "";
                List eventTriggers = lcdpComponent.getDynamicEventTriggers();
                for (Object eventTrigger : eventTriggers) {
                    Map e = DynDataUtil.asObject(eventTrigger).orElse(Collections.emptyMap());
                    if (!eventName.equals(e.get("name"))) continue;
                    oldName = String.valueOf(e.get("oName"));
                }
                if (entry.getTrigger().contains(String.valueOf(tab.get("slotName")))) {
                    String strTrigger = " @" + oldName + " =" + lcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)eventName);
                    triggers.append(strTrigger);
                }
                lcdpComponent.getTrigger().removeIf(trigger -> trigger.getName().equals(eventName));
            }
            for (Object entry : pageParamConfig.entrySet()) {
                HashMap<String, Map<String, Object>> moduleMap = new HashMap<String, Map<String, Object>>();
                String key = String.valueOf(entry.getKey());
                JSONObject value = JSON.parseObject((String)JSON.toJSONString(entry.getValue()));
                String propValue = pageName + index + ToolUtil.firstLetterToUpper((String)key);
                if (!ToolUtil.isNotEmpty((Object)value) || !ToolUtil.isNotEmpty(value.get("type"))) continue;
                String strProp = " :" + key + " = " + propValue;
                props.append(strProp);
                Map<String, Object> config = TabVoidVisitor.getRenderPageParamData(ctx, (Map.Entry<String, Object>)entry);
                if (config.size() > 0) {
                    moduleMap.put("params", config);
                }
                ctx.addComputed(propValue, RenderUtil.renderTemplate((String)"template/mobileui/vant/tab/vant_tab_props.ftl", moduleMap));
            }
            tab.put("url", routePath);
            tab.put("pageName", "<" + pageName + index + props + triggers + "/>");
            ctx.addImports("import " + pageName.toLowerCase() + index + " from '@/views" + routePath + "'");
            ctx.addComponent(pageName.toLowerCase() + index);
            ++index;
        }
        lcdpComponent.addRenderParam("tabs", (Object)tabList);
    }

    private static Map<String, Object> getRenderPageParamData(Ctx ctx, Map.Entry<String, Object> entry) throws LcdpException {
        HashMap<String, Object> paramConfig = new HashMap<String, Object>();
        ComponentReference componentReference = (ComponentReference)JSON.parseObject((String)entry.getValue().toString(), ComponentReference.class);
        ComponentData data = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)componentReference);
        if (null != data) {
            paramConfig.put(entry.getKey(), data.getRenderValue());
        } else {
            paramConfig.put(entry.getKey(), "''");
        }
        return paramConfig;
    }

    private void judgeHorizontalAndVerticalFill(LcdpComponent lcdpComponent, Ctx ctx) {
        boolean isHorizontalFill = lcdpComponent.isHorizontalFill();
        boolean isVerticalFill = lcdpComponent.isVerticalFill();
        List scrollList = JSON.parseArray((String)lcdpComponent.getProps().get("scrollList").toString(), HashMap.class);
        int realWidth = Integer.parseInt(StringUtils.removeEndIgnoreCase((String)String.valueOf(lcdpComponent.getInnerStyles().get("realWidth")), (String)"px"));
        int realHeight = Integer.parseInt(StringUtils.removeEndIgnoreCase((String)String.valueOf(lcdpComponent.getInnerStyles().get("realHeight")), (String)"px"));
        for (HashMap hashMap : scrollList) {
            int scrollWidth = Integer.parseInt(StringUtils.removeEndIgnoreCase((String)String.valueOf(hashMap.get("scrollWidth")), (String)"px"));
            int scrollHeight = Integer.parseInt(StringUtils.removeEndIgnoreCase((String)String.valueOf(hashMap.get("scrollHeight")), (String)"px"));
            int diffX = scrollWidth - realWidth;
            int diffY = scrollHeight - realHeight;
            if (isHorizontalFill) {
                hashMap.put("scrollWidth", "calc(100% + " + diffX + "px)");
            } else if (diffX == 0) {
                hashMap.put("scrollWidth", "100%");
            }
            if (isVerticalFill) {
                hashMap.put("scrollHeight", "calc(100% + " + diffY + "px)");
                continue;
            }
            if (diffY != 0) continue;
            hashMap.put("scrollHeight", "100%");
        }
        lcdpComponent.addRenderParam("scrolls", (Object)scrollList);
    }
}

