if (fileStr == null || fileStr == '') {
    return '';
}
let arr = fileStr.split(',');
let fileList = [];
arr.forEach(async (fileId) => {
    await hussarRequest.postJson('/attachment/uploadFileQuery', {'fileId': fileId}).then(async (res) => {
        if(res.success) {
            let prefix = res.data.fileName.substring(res.data.fileName.lastIndexOf('.') + 1);
            if(['png', 'jpg', 'jpeg', 'bmp', 'gif', 'webp', 'psd', 'svg', 'tiff'].indexOf(prefix.toLowerCase()) !== -1) {
                <#if isButtonStyle?? && isButtonStyle>
                    fileList.push({
                        url: res.data.fileName,
                        isImage: true,
                        id: fileId,
                        fileName: res.data.fileName,
                        fileSize: (res.data.byte / 1024).toFixed(2) + 'KB'
                    });
                    <#else>
                        await hussarRequest.getImg('/attachment/showPicture', {image: fileId}).then(img => {
                            let url = window.URL.createObjectURL(img);
                            fileList.push({
                                url: url,
                                isImage: true,
                                fileName: res.data.fileName,
                                id: fileId,
                                fileSize: (res.data.byte / 1024).toFixed(2) + 'KB'
                            });
                        }).catch(() => {
                            self.$toast('获取图片资源失败');
                        })
                </#if>
            } else {
                fileList.push({
                    url: res.data.fileName,
                    isImage: false,
                    fileName: res.data.fileName,
                    id: fileId,
                    fileSize: (res.data.byte / 1024).toFixed(2) + 'KB'
                });
            }
        } else {
            self.$toast(res || '文件数据请求错误')
        }
    }).catch((res) => {
        self.$toast(res || '文件数据请求异常');
    })
})
return fileList;
