/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.mobileui.vistor;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.speedcode.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.hussar.speedcode.codegenerator.core.component.visitor.VoidVisitor;
import com.jxdinfo.hussar.speedcode.codegenerator.core.ctx.Ctx;
import com.jxdinfo.hussar.speedcode.common.analysismodel.datas.DataSAnalysis;
import com.jxdinfo.hussar.speedcode.common.analysismodel.datas.DataSConditionAnalysis;
import com.jxdinfo.hussar.speedcode.common.analysismodel.datas.DataSFieldAnalysis;
import com.jxdinfo.hussar.speedcode.common.analysismodel.datas.DataSModelAnalysis;
import com.jxdinfo.hussar.speedcode.common.analysismodel.datas.DataSortConditionAnalysis;
import com.jxdinfo.hussar.speedcode.common.constant.CodePrefix;
import com.jxdinfo.hussar.speedcode.common.constant.CodeSuffix;
import com.jxdinfo.hussar.speedcode.common.exception.LcdpException;
import com.jxdinfo.hussar.speedcode.common.file.FileMappingService;
import com.jxdinfo.hussar.speedcode.common.util.RenderUtil;
import com.jxdinfo.hussar.speedcode.common.util.SpringUtil;
import com.jxdinfo.hussar.speedcode.common.util.ToolUtil;
import com.jxdinfo.hussar.speedcode.common.utils.ComponentDataUtil;
import com.jxdinfo.hussar.speedcode.common.utils.EventUtil;
import com.jxdinfo.hussar.speedcode.common.utils.QueryAttrUtil;
import com.jxdinfo.hussar.speedcode.common.utils.RenderVModelUtil;
import com.jxdinfo.hussar.speedcode.util.datamodel.DataModelUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ScatterMapEchartsVisitor
implements VoidVisitor {
    private FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);

    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        lcdpComponent.registerTemplatePath("/template/mobileui/vant/ScatterMapEcharts/el_scatterMapEcharts.ftl");
        this.renderAttrs(lcdpComponent, ctx);
        this.renderData(lcdpComponent, ctx);
        this.renderMethod(lcdpComponent, ctx);
    }

    private void renderAttrs(LcdpComponent lcdpComponent, Ctx ctx) {
        lcdpComponent.addAttr("ref", lcdpComponent.getInstanceKey() + "Ref");
    }

    private void renderData(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        String instanceKey = lcdpComponent.getInstanceKey();
        Integer width = lcdpComponent.getWidth();
        Integer height = lcdpComponent.getHeight();
        ctx.addData(instanceKey + "Data: null");
        if (ToolUtil.isNotEmpty(lcdpComponent.getStyles().get("borderTop"))) {
            String borderTop = String.valueOf(lcdpComponent.getStyles().get("borderTop"));
            ctx.addData(instanceKey + "BorderTop: " + borderTop.substring(0, borderTop.indexOf("px")));
        }
        if (ToolUtil.isNotEmpty(lcdpComponent.getStyles().get("borderBottom"))) {
            String borderBottom = String.valueOf(lcdpComponent.getStyles().get("borderBottom"));
            ctx.addData(instanceKey + "BorderBottom: " + borderBottom.substring(0, borderBottom.indexOf("px")));
        }
        if (ToolUtil.isNotEmpty(lcdpComponent.getStyles().get("borderLeft"))) {
            String borderLeft = String.valueOf(lcdpComponent.getStyles().get("borderLeft"));
            ctx.addData(instanceKey + "BorderLeft: " + borderLeft.substring(0, borderLeft.indexOf("px")));
        }
        if (ToolUtil.isNotEmpty(lcdpComponent.getStyles().get("borderRight"))) {
            String borderRight = String.valueOf(lcdpComponent.getStyles().get("borderRight"));
            ctx.addData(instanceKey + "BorderRight: " + borderRight.substring(0, borderRight.indexOf("px")));
        }
        ctx.addData(instanceKey + "Width: " + width);
        ctx.addData(instanceKey + "Height: " + height);
        ctx.addData("provincesJson: require('@/assets/js/setting')");
    }

    private void renderMethod(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException, IOException {
        Map maps;
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("instanceKey", lcdpComponent.getInstanceKey());
        String optionData = RenderVModelUtil.renderDataItemDataOrComputed((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)CodeSuffix._OPTION_DATA.getType(), Collections.singletonList("data"), (String)"{\ncityData: [],\nvalueData: [],\nlegendData: [],\nlatitudeData: [],\nlongitudeData: [],\n}");
        params.put("optionData", CodePrefix._SELF.getType() + optionData);
        if (!ComponentDataUtil.ComponentValueStatusEnum.NONE.equals((Object)ComponentDataUtil.getComponentValueStatus((LcdpComponent)lcdpComponent, (Ctx)ctx, Collections.singletonList("data")))) {
            params.put("isQuoteOrGetValue", "true");
        }
        if (ToolUtil.isNotEmpty((Object)(maps = lcdpComponent.getProps()))) {
            this.setParamValue(params, maps);
            this.setModelValue(lcdpComponent, ctx, params);
            ArrayList<String> args = new ArrayList<String>();
            args.add("n");
            ctx.addComputed(lcdpComponent.getInstanceKey() + "EchartsData", RenderUtil.renderTemplate((String)"/template/mobileui/vant/ScatterMapEcharts/el_scatterMapEcharts_computed.ftl", params));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "EchartsData", args, RenderUtil.renderTemplate((String)"/template/mobileui/vant/ScatterMapEcharts/el_scatterMapEcharts_watch.ftl", params));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "BorderBottom", args, RenderUtil.renderTemplate((String)"/template/mobileui/vant/ScatterMapEcharts/el_scatterMapEcharts_watch.ftl", params));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "BorderRight", args, RenderUtil.renderTemplate((String)"/template/mobileui/vant/ScatterMapEcharts/el_scatterMapEcharts_watch.ftl", params));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "BorderLeft", args, RenderUtil.renderTemplate((String)"/template/mobileui/vant/ScatterMapEcharts/el_scatterMapEcharts_watch.ftl", params));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "BorderTop", args, RenderUtil.renderTemplate((String)"/template/mobileui/vant/ScatterMapEcharts/el_scatterMapEcharts_watch.ftl", params));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "OptionData", args, RenderUtil.renderTemplate((String)"template/mobileui/vant/ScatterMapEcharts/el_scatterMapEcharts_watch.ftl", params));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "Width", args, RenderUtil.renderTemplate((String)"template/mobileui/vant/ScatterMapEcharts/el_scatterMapEcharts_watch.ftl", params));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "Height", args, RenderUtil.renderTemplate((String)"template/mobileui/vant/ScatterMapEcharts/el_scatterMapEcharts_watch.ftl", params));
            ctx.addMethod(lcdpComponent.getInstanceKey() + "OptionItem", RenderUtil.renderTemplate((String)"template/mobileui/vant/ScatterMapEcharts/el_scatterMapEcharts_Success.ftl", params));
            ctx.addMounted("this." + lcdpComponent.getInstanceKey() + "OptionItem();");
        }
    }

    private void setParamValue(Map<String, Object> params, Map<String, Object> maps) {
        params.put("titleText", maps.get("title"));
        params.put("titleColor", ToolUtil.isNotEmpty((Object)maps.get("titleColor")) ? maps.get("titleColor") : "#000");
        params.put("titleFontSize", ToolUtil.isNotEmpty((Object)maps.get("titleFontSize")) ? maps.get("titleFontSize") : "18");
        params.put("fontFamily", maps.get("fontFamily"));
        params.put("fontWeight", maps.get("fontWeight"));
        params.put("titleAlign", maps.get("titleAlign"));
        params.put("titleVerticalAlign", maps.get("titleVerticalAlign"));
        params.put("titleLeft", maps.get("titleLeft"));
        params.put("titleTop", maps.get("titleTop"));
        params.put("titleBackgroundColor", ToolUtil.isNotEmpty((Object)maps.get("titleBackgroundColor")) ? maps.get("titleBackgroundColor") : "transparent");
        params.put("tooltipBgColor", maps.get("tooltipBgColor"));
        params.put("toolColor", ToolUtil.isNotEmpty((Object)maps.get("toolColor")) ? maps.get("toolColor") : "#666");
        params.put("toolFontSize", ToolUtil.isNotEmpty((Object)maps.get("toolFontSize")) ? maps.get("toolFontSize") : "12");
        params.put("toolFontFamily", maps.get("toolFontFamily"));
        params.put("toolFontWeight", maps.get("toolFontWeight"));
        params.put("toolFontStyle", maps.get("toolFontStyle"));
        params.put("toolLineHeight", maps.get("toolLineHeight"));
        params.put("toolShow", Optional.ofNullable(maps.get("toolShow")).orElse(false));
        params.put("toolPaddingTop", ToolUtil.isNotEmpty((Object)maps.get("toolPaddingTop")) ? maps.get("toolPaddingTop") : "10");
        params.put("toolPaddingLeft", ToolUtil.isNotEmpty((Object)maps.get("toolPaddingLeft")) ? maps.get("toolPaddingLeft") : "10");
        params.put("toolShadow", maps.get("toolShadow"));
        params.put("isShowFlag", Optional.ofNullable(maps.get("isShowFlag")).orElse(false));
        params.put("legendLocation", ToolUtil.isNotEmpty((Object)maps.get("legendLocation")) ? maps.get("legendLocation") : "center");
        params.put("legendColor", ToolUtil.isNotEmpty((Object)maps.get("legendColor")) ? maps.get("legendColor") : "#999999");
        params.put("legendFontSize", ToolUtil.isNotEmpty((Object)maps.get("legendFontSize")) ? maps.get("legendFontSize") : "16");
        params.put("legendFontFamily", maps.get("legendFontFamily"));
        params.put("legendFontWeight", maps.get("legendFontWeight"));
        params.put("legendFontStyle", maps.get("legendFontStyle"));
        params.put("itemWidth", Optional.ofNullable(maps.get("itemWidth")).orElse(22));
        params.put("itemHeight", Optional.ofNullable(maps.get("itemHeight")).orElse(10));
        params.put("itemGap", Optional.ofNullable(maps.get("itemGap")).orElse(20));
        params.put("itemOrient", ToolUtil.isNotEmpty((Object)maps.get("itemOrient")) ? maps.get("itemOrient") : "horizontal");
        params.put("itemIcon", maps.get("itemIcon"));
        params.put("itemInactiveColor", maps.get("itemInactiveColor"));
        params.put("labelShow", Optional.ofNullable(maps.get("labelShow")).orElse(false));
        params.put("labelColor", maps.get("labelColor"));
        params.put("labelFontSize", ToolUtil.isNotEmpty((Object)maps.get("labelFontSize")) ? maps.get("labelFontSize") : "14");
        params.put("labelFontWeight", maps.get("labelFontWeight"));
        params.put("labelFontFamily", maps.get("labelFontFamily"));
        params.put("symbolSize", Optional.ofNullable(maps.get("symbolSize")).orElse(18));
        params.put("symbolIcon", maps.get("symbolIcon"));
        Map tempMap = (Map)maps.get("symbolIcon");
        params.put("imgRelativePath", tempMap.get("imgRelativePath"));
        params.put("imgForSelect", tempMap.get("imgForSelect"));
        params.put("areaColor", Optional.ofNullable(maps.get("areaColor")).orElse("#409EFF"));
        params.put("areaBorderColor", Optional.ofNullable(maps.get("areaBorderColor")).orElse("#FFFFFF"));
        params.put("areaBorderWidth", Optional.ofNullable(maps.get("areaBorderWidth")).orElse(1));
        params.put("areaEmphasisColor", maps.get("areaEmphasisColor"));
        params.put("effectScatter", Optional.ofNullable(maps.get("effectScatter")).orElse(false));
        params.put("shadowColor", maps.get("shadowColor"));
        params.put("shadowBlur", maps.get("shadowBlur"));
        params.put("markerColor", maps.get("markerColor"));
        params.put("currentProvince", maps.get("currentProvince"));
        params.put("currentProvinceName", maps.get("currentProvinceName"));
        params.put("currentCity", maps.get("currentCity"));
        params.put("topicColorStr", maps.get("topicColor").toString());
    }

    private void setModelValue(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> params) throws LcdpException, IOException {
        DataSAnalysis datasAnalysis = (DataSAnalysis)JSONObject.parseObject((String)JSONObject.toJSONString((Object)lcdpComponent.getDatas()), DataSAnalysis.class);
        DataSModelAnalysis datasModelAnalysis = datasAnalysis.getDatamodel();
        if (ToolUtil.isNotEmpty((Object)datasModelAnalysis)) {
            DataSConditionAnalysis datasConditionAnalysis = datasModelAnalysis.getCondition();
            Map datasFieldAnalysisMap = datasModelAnalysis.getFields();
            String labelField = "";
            String valueField = "";
            String legendField = "";
            String longitudeField = "";
            String latitudeField = "";
            if (ToolUtil.isNotEmpty((Object)datasFieldAnalysisMap)) {
                for (Map.Entry fieldList : datasFieldAnalysisMap.entrySet()) {
                    List fieldAnalyses = (List)fieldList.getValue();
                    for (DataSFieldAnalysis datasFieldAnalysis : fieldAnalyses) {
                        String dataItemValue;
                        List dataItemPath = datasFieldAnalysis.getDataItemPath();
                        if (!ToolUtil.isNotEmpty((Object)dataItemPath)) continue;
                        switch (dataItemValue = (String)dataItemPath.get(dataItemPath.size() - 1)) {
                            case "label": {
                                labelField = datasFieldAnalysis.getFieldName();
                                break;
                            }
                            case "value": {
                                valueField = datasFieldAnalysis.getFieldName();
                                break;
                            }
                            case "legend": {
                                legendField = datasFieldAnalysis.getFieldName();
                                break;
                            }
                            case "longitude": {
                                longitudeField = datasFieldAnalysis.getFieldName();
                                break;
                            }
                            case "latitude": {
                                latitudeField = datasFieldAnalysis.getFieldName();
                                break;
                            }
                        }
                    }
                }
            }
            if (ToolUtil.isNotEmpty((Object)labelField) && ToolUtil.isNotEmpty((Object)valueField)) {
                String sortConditionName;
                DataSortConditionAnalysis dataSortConditionAnalysis;
                String querySelectionName;
                List conditionList;
                String operationName = "hussarQuery";
                String dataSelectId = lcdpComponent.getInstanceKey();
                String apiFileName = "";
                String apiFilePath = "";
                String dataModelId = datasModelAnalysis.getDataModelId();
                if (ToolUtil.isNotEmpty((Object)dataModelId) && ToolUtil.isNotEmpty((Object)DataModelUtil.getDataModelBase((String)dataModelId))) {
                    apiFileName = this.fileMappingService.getFileName(dataModelId);
                    apiFilePath = this.fileMappingService.getImportPath(dataModelId).toLowerCase();
                }
                if (ToolUtil.isNotEmpty((Object)datasConditionAnalysis) && ToolUtil.isNotEmpty((Object)(conditionList = datasConditionAnalysis.getQueryConditionModelList()))) {
                    params.put("queryAttr", QueryAttrUtil.getQueryAttr((List)conditionList, (Ctx)ctx));
                    params.put("queryCheck", QueryAttrUtil.getQueryCheck((List)conditionList, (String)apiFileName).toString());
                }
                if (ToolUtil.isNotEmpty((Object)(querySelectionName = datasConditionAnalysis.getSelectCondition()))) {
                    operationName = operationName + querySelectionName;
                }
                if (ToolUtil.isNotEmpty((Object)(dataSortConditionAnalysis = datasModelAnalysis.getSortCondition())) && ToolUtil.isNotEmpty((Object)(sortConditionName = dataSortConditionAnalysis.getSortCondition()))) {
                    operationName = operationName + sortConditionName;
                }
                if (ToolUtil.isNotEmpty((Object)apiFilePath)) {
                    EventUtil.addCtxImport((Ctx)ctx, (String)apiFileName, (String)apiFilePath);
                }
                params.put("importName", apiFileName);
                params.put("importMethod", operationName);
                params.put("axisCols", labelField);
                params.put("seriesCols", valueField);
                params.put("legendCols", legendField);
                params.put("longitudeCols", longitudeField);
                params.put("latitudeCols", latitudeField);
            }
        }
    }
}

