/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.ionicui.utils;

import com.jxdinfo.speedcode.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.speedcode.codegenerator.core.component.visitor.BaseProvideVisitor;
import com.jxdinfo.speedcode.codegenerator.core.component.visitor.ValueVisitor;
import com.jxdinfo.speedcode.codegenerator.core.ctx.Ctx;
import com.jxdinfo.speedcode.common.analysismodel.reference.CalculateAttribute;
import com.jxdinfo.speedcode.common.analysismodel.reference.ComponentReference;
import com.jxdinfo.speedcode.common.constant.CodeSuffix;
import com.jxdinfo.speedcode.common.constant.DataFromEnum;
import com.jxdinfo.speedcode.common.exception.LcdpException;
import com.jxdinfo.speedcode.common.properties.EnvVarsProperties;
import com.jxdinfo.speedcode.common.util.RenderUtil;
import com.jxdinfo.speedcode.common.util.SpringUtil;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import com.jxdinfo.speedcode.common.utils.ComponentBindUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class IonicReferenceUtil {
    private static final EnvVarsProperties envVarsProperties = (EnvVarsProperties)SpringUtil.getBean(EnvVarsProperties.class);

    public static void renderReferenceData(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        if (ComponentBindUtil.isSetReference((LcdpComponent)lcdpComponent)) {
            if (IonicReferenceUtil.judgeComponentArrayReference(lcdpComponent, ctx)) {
                IonicReferenceUtil.renderArrayReferenceData(lcdpComponent, ctx);
            } else {
                ComponentBindUtil.renderReferenceData((LcdpComponent)lcdpComponent, (Ctx)ctx, (boolean)true);
            }
        }
    }

    private static void renderArrayReferenceData(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        ComponentReference reference;
        HashMap<String, String> renderParams = new HashMap<String, String>();
        int insData = 0;
        ArrayList<String> param = new ArrayList<String>();
        if (ToolUtil.isNotEmpty((Object)IonicReferenceUtil.getSetReferenceCol(lcdpComponent, ctx)) && ComponentBindUtil.isGetReference((LcdpComponent)lcdpComponent)) {
            reference = ComponentBindUtil.getComponentGetReference((LcdpComponent)lcdpComponent);
            ComponentReference setReference = ComponentBindUtil.getComponentSetReference((LcdpComponent)lcdpComponent);
            LcdpComponent bindComponent = (LcdpComponent)ctx.getComponentMap().get(setReference.getInstanceKey());
            ValueVisitor referVisitor = (ValueVisitor)bindComponent.getProvideVisitor("value");
            bindComponent.accept((BaseProvideVisitor)referVisitor, ctx, null);
            String referData = ComponentBindUtil.dealPrefixThis((String)referVisitor.getValue(setReference.getInstanceData()));
            if (referData.contains(".")) {
                referData = referData.substring(referData.indexOf(46) + 1);
            }
            param.add("p0");
            insData = 1;
            renderParams.put("insData", "p0." + referData);
        } else {
            reference = ComponentBindUtil.getComponentSetReference((LcdpComponent)lcdpComponent);
        }
        List<String> methodParam = IonicReferenceUtil.getArrayComponentParam(lcdpComponent, ctx);
        if (ToolUtil.isNotEmpty(methodParam)) {
            StringBuilder calRes = new StringBuilder(128);
            String dataType = reference.getConfigDataType();
            if ("num".equals(dataType)) {
                calRes.append("let res = 0;\n");
            } else {
                calRes.append("let res = '';\n");
            }
            for (int i = 0; i < methodParam.size() - insData; ++i) {
                param.add("p" + (i + 1));
            }
            if (ToolUtil.isNotEmpty((Object)reference.getFormula())) {
                if (methodParam.size() == 2 && insData == 0) {
                    calRes.append(ComponentBindUtil.timeCalculator((LcdpComponent)lcdpComponent, (boolean)false));
                    if ("num".equals(dataType)) {
                        calRes.append("else {  res = ").append("eval(").append(reference.getFormula()).append(");\n }");
                    } else {
                        calRes.append("else {  res = ").append(reference.getFormula()).append(";\n }");
                    }
                } else if ("num".equals(dataType)) {
                    calRes.append("res = ").append("eval(").append(reference.getFormula()).append(");\n ");
                } else {
                    calRes.append("res = ").append(reference.getFormula()).append(";\n");
                }
            } else if ("num".equals(dataType)) {
                calRes.append("res = Number(p1);\n");
            } else {
                calRes.append("res = p1;\n");
            }
            renderParams.put("comParam", StringUtils.join(param, (String)","));
            renderParams.put("referBody", calRes.toString());
            renderParams.put("referResult", "res");
            ctx.addComputed(lcdpComponent.getInstanceKey() + CodeSuffix._DATA.getType(), RenderUtil.renderTemplate((String)"/template/ionicui/event/IonicArrayReference.ftl", renderParams));
        }
    }

    public static boolean isBindList(LcdpComponent lcdpComponent) {
        return ToolUtil.isNotEmpty(lcdpComponent.getRenderParams().get("listKey"));
    }

    public static String getSetReferenceCol(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        ComponentReference componentReference = ComponentBindUtil.getComponentSetReference((LcdpComponent)lcdpComponent);
        if (ToolUtil.isNotEmpty((Object)componentReference) && ToolUtil.isNotEmpty((Object)componentReference.getInstanceData()) && componentReference.getInstanceData().size() > 1) {
            return ComponentBindUtil.dealPrefixThis((String)ComponentBindUtil.getComponentRelateColData((String)componentReference.getInstanceKey(), (List)componentReference.getInstanceData(), (Ctx)ctx));
        }
        return null;
    }

    public static boolean judgeComponentArrayReference(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        if (ToolUtil.isNotEmpty((Object)lcdpComponent) && ComponentBindUtil.isSetReference((LcdpComponent)lcdpComponent)) {
            ComponentReference setReference = ComponentBindUtil.getComponentSetReference((LcdpComponent)lcdpComponent);
            if (ComponentBindUtil.isGetReference((LcdpComponent)lcdpComponent)) {
                ComponentReference getReference = ComponentBindUtil.getComponentGetReference((LcdpComponent)lcdpComponent);
                return IonicReferenceUtil.judgeReferenceArrayReference(lcdpComponent, getReference, ctx);
            }
            return IonicReferenceUtil.judgeReferenceArrayReference(lcdpComponent, setReference, ctx);
        }
        return false;
    }

    private static boolean judgeReferenceArrayReference(LcdpComponent lcdpComponent, ComponentReference reference, Ctx ctx) throws LcdpException {
        if (DataFromEnum.INSTANCE.getValue().equals(reference.getType())) {
            return IonicReferenceUtil.judgeInstanceArrayReference(lcdpComponent, reference, ctx);
        }
        if (DataFromEnum.CALCULATE.getValue().equals(reference.getType())) {
            return IonicReferenceUtil.judgeCalculateArrayReference(lcdpComponent, reference, ctx);
        }
        return false;
    }

    private static boolean judgeInstanceArrayReference(LcdpComponent lcdpComponent, ComponentReference reference, Ctx ctx) throws LcdpException {
        LcdpComponent bindComponent;
        List referIds = reference.getInstanceData();
        if (ToolUtil.isNotEmpty((Object)referIds) && (referIds.size() == 1 || ComponentBindUtil.isGetReference((LcdpComponent)lcdpComponent)) && ToolUtil.isNotEmpty((Object)(bindComponent = (LcdpComponent)ctx.getComponentMap().get(reference.getInstanceKey())))) {
            ValueVisitor referVisitor = (ValueVisitor)bindComponent.getProvideVisitor("value");
            bindComponent.accept((BaseProvideVisitor)referVisitor, ctx, null);
            String referValue = referVisitor.getValue(referIds);
            return IonicReferenceUtil.judgeArrayReference(referValue);
        }
        return false;
    }

    private static boolean judgeCalculateArrayReference(LcdpComponent lcdpComponent, ComponentReference reference, Ctx ctx) throws LcdpException {
        List referIds = reference.getCalData();
        for (CalculateAttribute calculateAttribute : referIds) {
            LcdpComponent bindComponent;
            List calculateAttributes;
            if (!DataFromEnum.INSTANCE.getValue().equals(calculateAttribute.getType()) || !ToolUtil.isNotEmpty((Object)(calculateAttributes = calculateAttribute.getInstanceData())) || !ToolUtil.isNotEmpty((Object)(bindComponent = (LcdpComponent)ctx.getComponentMap().get(calculateAttribute.getInstanceKey())))) continue;
            ValueVisitor referVisitor = (ValueVisitor)bindComponent.getProvideVisitor("value");
            bindComponent.accept((BaseProvideVisitor)referVisitor, ctx, null);
            String referValue = referVisitor.getValue(calculateAttributes);
            if (!IonicReferenceUtil.judgeArrayReference(referValue)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getArrayComponentParam(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        ComponentReference reference;
        ArrayList<String> params = new ArrayList<String>();
        if (ToolUtil.isNotEmpty((Object)IonicReferenceUtil.getSetReferenceCol(lcdpComponent, ctx)) && ComponentBindUtil.isGetReference((LcdpComponent)lcdpComponent)) {
            reference = ComponentBindUtil.getComponentGetReference((LcdpComponent)lcdpComponent);
            ComponentReference setReference = ComponentBindUtil.getComponentSetReference((LcdpComponent)lcdpComponent);
            LcdpComponent bindComponent = (LcdpComponent)ctx.getComponentMap().get(setReference.getInstanceKey());
            ValueVisitor referVisitor = (ValueVisitor)bindComponent.getProvideVisitor("value");
            bindComponent.accept((BaseProvideVisitor)referVisitor, ctx, null);
            params.add(ComponentBindUtil.dealPrefixThis((String)referVisitor.getValue(null)));
        } else {
            reference = ComponentBindUtil.getComponentSetReference((LcdpComponent)lcdpComponent);
        }
        if (ToolUtil.isNotEmpty((Object)reference) && ToolUtil.isNotEmpty((Object)reference.getType())) {
            if (DataFromEnum.INSTANCE.getValue().equals(reference.getType())) {
                String referResult = ComponentBindUtil.getReferValueByKeyAndData((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)reference.getInstanceKey(), (List)reference.getInstanceData(), (boolean)false);
                if (ToolUtil.isNotEmpty((Object)referResult)) {
                    params.add(ComponentBindUtil.dealPrefixThis((String)referResult));
                }
            } else if (DataFromEnum.CALCULATE.getValue().equals(reference.getType())) {
                for (CalculateAttribute calculateAttribute : reference.getCalData()) {
                    if (DataFromEnum.INSTANCE.getValue().equals(calculateAttribute.getType())) {
                        String referResult = ComponentBindUtil.getReferValueByKeyAndData((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)calculateAttribute.getInstanceKey(), (List)calculateAttribute.getInstanceData(), (boolean)true);
                        if (!ToolUtil.isNotEmpty((Object)referResult)) continue;
                        params.add(ComponentBindUtil.dealPrefixThis((String)referResult));
                        continue;
                    }
                    if (DataFromEnum.INPUT.getValue().equals(calculateAttribute.getType())) {
                        params.add("'" + calculateAttribute.getConfigData() + "'");
                        continue;
                    }
                    IonicReferenceUtil.dealSessionAndPageParam(params, calculateAttribute.getType(), calculateAttribute.getConfigData());
                }
            } else if (DataFromEnum.INPUT.getValue().equals(reference.getType()) && ToolUtil.isNotEmpty((Object)reference.getConfigData())) {
                params.add("'" + reference.getConfigData() + "'");
            } else {
                IonicReferenceUtil.dealSessionAndPageParam(params, reference.getType(), reference.getConfigData());
            }
        }
        return params;
    }

    private static void dealSessionAndPageParam(List<String> params, String type, String configData) {
        if (type.equals(DataFromEnum.SESSION.getValue())) {
            Map sessionConfig = envVarsProperties.getSession();
            if (ToolUtil.isNotEmpty((Object)configData)) {
                String getSessionValue = "sessionStorage.getItem(" + (String)sessionConfig.get(configData) + ")";
                params.add(getSessionValue);
            }
        } else if (type.equals(DataFromEnum.PAGE_PARAM.getValue())) {
            params.add("$route.query." + configData);
        }
    }

    private static boolean judgeArrayReference(String referValue) {
        int lastPointIndex = referValue.lastIndexOf(".");
        return !referValue.contains("function") && lastPointIndex > 0 && referValue.substring(0, lastPointIndex).endsWith(CodeSuffix._LIST_ITEM_DATA.getType());
    }
}

