/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.ionicui.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.speedcode.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.speedcode.codegenerator.core.component.visitor.BaseProvideVisitor;
import com.jxdinfo.speedcode.codegenerator.core.component.visitor.ValueVisitor;
import com.jxdinfo.speedcode.codegenerator.core.ctx.Ctx;
import com.jxdinfo.speedcode.common.analysismodel.reference.ComponentReference;
import com.jxdinfo.speedcode.common.constant.CodePrefix;
import com.jxdinfo.speedcode.common.exception.LcdpException;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import java.util.Map;

public class FieldReferenceResolver {
    private Ctx ctx;
    private LcdpComponent com;
    private Map<String, Object> params;
    private String field = CodePrefix._DATA.getType();
    private String reference = "reference";

    public FieldReferenceResolver(Ctx ctx, LcdpComponent com, Map<String, Object> params) {
        this.ctx = ctx;
        this.com = com;
        this.params = params;
    }

    public FieldReferenceResolver(Ctx ctx, LcdpComponent com, Map<String, Object> params, String field, String reference) {
        this.ctx = ctx;
        this.com = com;
        this.params = params;
        this.field = field;
        this.reference = reference;
    }

    public String getLvalueOfInstance() throws LcdpException {
        ComponentReference setRef = this.getSetReferenceOfInstance();
        if (setRef == null) {
            return this.getOwnedLvalue();
        }
        LcdpComponent targetCom = (LcdpComponent)this.ctx.getComponentMap().get(setRef.getInstanceKey());
        if (ToolUtil.isEmpty((Object)targetCom)) {
            System.err.println("\u6e32\u67d3'" + this.com.getInstanceKey() + "'\u7ec4\u4ef6\u65f6\u627e\u4e0d\u5230\u503c\u5f15\u7528\uff1a" + setRef.getInstanceKey() + "'\u5bf9\u5e94\u7684\u7ec4\u4ef6");
            return this.getOwnedLvalue();
        }
        ValueVisitor targetVisitor = (ValueVisitor)targetCom.getProvideVisitor("value");
        targetCom.accept((BaseProvideVisitor)targetVisitor, this.ctx, null);
        String lvalue = targetVisitor.getValue(setRef.getInstanceData());
        if (ToolUtil.isEmpty((Object)lvalue)) {
            return this.getOwnedLvalue();
        }
        return lvalue;
    }

    public boolean isOwned() {
        ComponentReference setRef = this.getSetReference();
        return setRef == null || ToolUtil.isEmpty((Object)setRef.getType());
    }

    public boolean isInstanceReference() {
        return this.getSetReferenceOfInstance() != null;
    }

    public String getOwnedLvalue() {
        return this.getThisPrefix() + this.getOwnedField();
    }

    public String getOwnedField() {
        return this.com.getInstanceKey() + ToolUtil.firstLetterToUpper((String)this.field);
    }

    private ComponentReference getSetReferenceOfInstance() {
        ComponentReference setRef = this.getSetReference();
        if (setRef != null && "instance".equals(setRef.getType())) {
            return setRef;
        }
        return null;
    }

    private ComponentReference getSetReference() {
        JSONObject ref;
        if (ToolUtil.isNotEmpty(this.com.getProps().get(this.reference)) && ToolUtil.isNotEmpty((Object)(ref = (JSONObject)this.com.getProps().get(this.reference)).get((Object)"setReference"))) {
            return (ComponentReference)JSON.toJavaObject((JSON)((JSONObject)ref.get((Object)"setReference")), ComponentReference.class);
        }
        return null;
    }

    private String getThisPrefix() {
        String thisPrefix = CodePrefix._THIS.getType();
        if (ToolUtil.isNotEmpty(this.params) && ToolUtil.isNotEmpty((Object)this.params.get(CodePrefix.SELF.getType()))) {
            thisPrefix = CodePrefix._SELF.getType();
        }
        return thisPrefix;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }
}

