/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.ionicui.event;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.speedcode.codegenerator.core.action.Action;
import com.jxdinfo.speedcode.codegenerator.core.action.visitor.ActionVisitor;
import com.jxdinfo.speedcode.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.speedcode.codegenerator.core.ctx.Ctx;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSModelAnalysis;
import com.jxdinfo.speedcode.common.render.RenderCore;
import com.jxdinfo.speedcode.common.render.RenderResult;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import com.jxdinfo.speedcode.common.utils.EventUtil;
import com.jxdinfo.speedcode.file.filemapping.service.FileMappingService;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.ionicui.TableQueryAction")
public class IonicTableQuery
implements ActionVisitor {
    private final FileMappingService fileMappingService;

    @Autowired
    public IonicTableQuery(FileMappingService fileMappingService) {
        this.fileMappingService = fileMappingService;
    }

    public void visitor(Action action, Ctx ctx) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath("/template/ionicui/event/TableQuery.ftl");
        LcdpComponent myLcdpComponent = action.getCurrentLcdpComponent();
        String trigger = action.getTrigger();
        String triggerName = myLcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)trigger);
        map.put("trigger", triggerName);
        Map params = action.getParamValues();
        String operationName = "";
        String dataTableId = "";
        String apiFileName = "";
        String apiFilePath = "";
        JSONObject tableQueryObj = (JSONObject)params.get("tableQuery");
        if (ToolUtil.isNotEmpty((Object)tableQueryObj)) {
            String dataModelId;
            DataSAnalysis dataSAnalysis;
            DataSModelAnalysis dataModelAnalysis;
            LcdpComponent dataTableComponent;
            dataTableId = tableQueryObj.getString("instanceKey");
            operationName = tableQueryObj.getString("operationName");
            if (ToolUtil.isNotEmpty((Object)dataTableId) && ToolUtil.isNotEmpty((Object)(dataTableComponent = (LcdpComponent)ctx.getComponentMap().get(dataTableId))) && ToolUtil.isNotEmpty((Object)(dataModelAnalysis = (dataSAnalysis = (DataSAnalysis)JSONObject.parseObject((String)JSONObject.toJSONString((Object)dataTableComponent.getDatas()), DataSAnalysis.class)).getDatamodel())) && ToolUtil.isNotEmpty((Object)(dataModelId = dataModelAnalysis.getDataModelId()))) {
                apiFileName = this.fileMappingService.getFileName(dataModelId);
                apiFilePath = this.fileMappingService.getImportPath(dataModelId).toLowerCase();
            }
        }
        if (ToolUtil.isNotEmpty((Object)apiFilePath)) {
            EventUtil.addCtxImport((Ctx)ctx, (String)apiFileName, (String)apiFilePath);
        }
        map.put("importName", apiFileName);
        map.put("importMethod", operationName);
        map.put("instanceKey", dataTableId);
        renderCore.registerParam(map);
        RenderResult renderResult = renderCore.render();
        if (renderResult.isStatus()) {
            ctx.addMethod(trigger, triggerName, renderResult.getRenderString());
        }
    }
}

