/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.file.filemapping.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.speedcode.common.exception.LcdpException;
import com.jxdinfo.speedcode.common.exception.LcdpExceptionEnum;
import com.jxdinfo.speedcode.common.model.BaseFile;
import com.jxdinfo.speedcode.common.properties.SpeedCodeProperties;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import com.jxdinfo.speedcode.file.datafile.service.DataFileService;
import com.jxdinfo.speedcode.file.filemapping.service.FileMappingService;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FileMappingServiceImpl
implements FileMappingService {
    private final DataFileService dataFileService;
    private final SpeedCodeProperties speedCodeProperties;

    @Autowired
    public FileMappingServiceImpl(DataFileService dataFileService, SpeedCodeProperties speedCodeProperties) {
        this.dataFileService = dataFileService;
        this.speedCodeProperties = speedCodeProperties;
    }

    @Override
    public Map<String, String> fileMappingCache() throws LcdpException {
        return this.dataFileService.getFileMapping();
    }

    @Override
    public void fileMappingCacheEvict() {
        this.dataFileService.fileMappingEvict();
    }

    @Override
    public String getFilePathById(String id) throws LcdpException {
        Map<String, String> fileMapping = this.fileMappingCache();
        String filePath = "";
        if (fileMapping != null) {
            filePath = fileMapping.get(id);
        }
        return filePath;
    }

    @Override
    public String getMetaPath(String id) throws LcdpException {
        String path = this.fileMappingCache().get(id);
        if (ToolUtil.isEmpty((Object)id) || ToolUtil.isEmpty((Object)path)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, id);
        }
        return path;
    }

    @Override
    public String getDataPath(String id) throws LcdpException {
        if ("#".equals(id)) {
            return "";
        }
        String path = this.getMetaPath(id).replace(".meta", "");
        if (ToolUtil.isEmpty((Object)id) || ToolUtil.isEmpty((Object)path)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, id);
        }
        return path;
    }

    @Override
    public String getFormatPath(String id) throws LcdpException {
        String dataPath = this.getDataPath(id);
        int location = (dataPath = dataPath.replace(File.separator, "/")).lastIndexOf("/");
        if (location != -1) {
            String name = dataPath.substring(location);
            int suffix = name.lastIndexOf(".");
            if (suffix != -1) {
                name = name.substring(0, suffix);
            }
            dataPath = dataPath.substring(0, location) + name;
        }
        return dataPath;
    }

    @Override
    public String getFormatParentPath(String id) throws LcdpException {
        String fileFormatPath = this.getFormatPath(id);
        int location = fileFormatPath.lastIndexOf("/");
        if (location != -1) {
            fileFormatPath = fileFormatPath.substring(0, location);
        }
        return fileFormatPath;
    }

    @Override
    public String getImportPath(String id) throws LcdpException {
        String fileFormatPath = this.getFormatPath(id);
        if (ToolUtil.isNotEmpty((Object)fileFormatPath) && "/".equals(fileFormatPath.substring(0, 1))) {
            fileFormatPath = ToolUtil.formatToDividePath((String)this.speedCodeProperties.getFrontApiPath()).replace("/src", "@") + "/" + fileFormatPath.substring(1);
        }
        return fileFormatPath;
    }

    @Override
    public String getFileName(String id) throws LcdpException {
        String fileFormatPath = this.getFormatPath(id);
        int location = fileFormatPath.lastIndexOf("/");
        if (location != -1) {
            fileFormatPath = fileFormatPath.substring(location + 1);
        }
        return fileFormatPath;
    }

    @Override
    public String getCamelFileNameWithModule(String id) throws LcdpException {
        String pagePath = this.getFormatPath(id);
        String[] paths = pagePath.split("/");
        StringBuilder pageNameWithModuleBuilder = new StringBuilder();
        for (String path : paths) {
            if ("".equals(path)) continue;
            pageNameWithModuleBuilder.append(ToolUtil.firstLetterToUpper((String)path));
        }
        return pageNameWithModuleBuilder.toString();
    }

    @Override
    public BaseFile getPageInfoById(String id) throws LcdpException, IOException {
        File metaFile;
        String metaPath = this.getMetaPath(id);
        if (ToolUtil.isNotEmpty((Object)metaPath) && (metaFile = new File(ToolUtil.pathFomatterByOS((String)(this.speedCodeProperties.getProjectAndCodePath() + metaPath)))).exists()) {
            return (BaseFile)JSON.parseObject((String)FileUtils.readFileToString((File)metaFile, (String)"UTF-8"), BaseFile.class);
        }
        return null;
    }
}

