/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.file.datafile.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.speedcode.common.annotation.ExceptionCatcher;
import com.jxdinfo.speedcode.common.exception.LcdpException;
import com.jxdinfo.speedcode.common.exception.LcdpExceptionEnum;
import com.jxdinfo.speedcode.common.model.BaseFile;
import com.jxdinfo.speedcode.common.properties.SpeedCodeProperties;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import com.jxdinfo.speedcode.file.datafile.service.DataFileService;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class DataFileServiceImpl
implements DataFileService {
    private final SpeedCodeProperties speedCodeProperties;
    private static final String cache = "speedFileMappingCache";

    @Autowired
    public DataFileServiceImpl(SpeedCodeProperties speedCodeProperties) {
        this.speedCodeProperties = speedCodeProperties;
    }

    @Override
    @Cacheable(value={"speedFileMappingCache"})
    @ExceptionCatcher
    public Map<String, String> getFileMapping() throws LcdpException {
        HashMap<String, String> map = new HashMap<String, String>();
        File file = new File(this.speedCodeProperties.getProjectAndCodePath());
        this.iteratorFile(file, map, file);
        return map;
    }

    @Override
    @CacheEvict(value={"speedFileMappingCache"}, allEntries=true)
    public void fileMappingEvict() {
    }

    private void iteratorFile(File file, Map<String, String> fileMappingMap, File rootFile) throws LcdpException {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                if (files != null) {
                    for (File childFile : files) {
                        this.iteratorFile(childFile, fileMappingMap, rootFile);
                    }
                }
            } else if (file.getName().endsWith(".meta")) {
                String id = "";
                try {
                    BaseFile baseFile = (BaseFile)JSONObject.parseObject((String)FileUtils.readFileToString((File)file, (String)"UTF-8"), BaseFile.class);
                    id = baseFile.getId();
                }
                catch (Exception e) {
                    throw new LcdpException(LcdpExceptionEnum.FILE_READ_FAIL, file.getAbsolutePath());
                }
                if (ToolUtil.isNotEmpty((Object)id)) {
                    String relativePath = file.getAbsolutePath().replace(rootFile.getAbsolutePath(), "");
                    if (ToolUtil.isNotEmpty((Object)fileMappingMap.get(id))) {
                        throw new LcdpException(LcdpExceptionEnum.SAME_FILE_ID, fileMappingMap.get(id) + "\n" + relativePath);
                    }
                    fileMappingMap.put(id, relativePath);
                }
            }
        }
    }
}

