/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.datasource.config.converts;

import com.jxdinfo.speedcode.common.util.ToolUtil;
import com.jxdinfo.speedcode.datasource.config.rules.DbColumnType;
import com.jxdinfo.speedcode.datasource.config.rules.PropertyType;

public class DataModelFieldTypeConvert {
    public static final String STRING = "string";
    public static final String INT = "int";
    public static final String DOUBLE = "double";
    public static final String DATE = "date";
    public static final String BOOLEAN = "boolean";
    public static final String OBJECT = "object";
    public static final String ARRAY = "array";

    public static PropertyType getDbColumnType(String type) {
        String lowerCaseType;
        PropertyType propertyType = new PropertyType(DbColumnType.STRING.getType(), DbColumnType.STRING.getPkg());
        if (ToolUtil.isEmpty((Object)type)) {
            return propertyType;
        }
        switch (lowerCaseType = type.toLowerCase()) {
            case "int": {
                propertyType.setType(DbColumnType.INTEGER.getType());
                propertyType.setImportT(DbColumnType.INTEGER.getPkg());
                break;
            }
            case "double": {
                propertyType.setType(DbColumnType.DOUBLE.getType());
                propertyType.setImportT(DbColumnType.DOUBLE.getPkg());
                break;
            }
            case "date": {
                propertyType.setType(DbColumnType.DATE_DATE.getType());
                propertyType.setImportT(DbColumnType.DATE_DATE.getPkg());
                break;
            }
            case "boolean": {
                propertyType.setType(DbColumnType.BASE_BOOLEAN.getType());
                propertyType.setImportT(DbColumnType.BASE_BOOLEAN.getPkg());
                break;
            }
            case "object": {
                propertyType.setType(DbColumnType.OBJECT.getType());
                propertyType.setImportT(DbColumnType.OBJECT.getPkg());
                break;
            }
            case "array": {
                propertyType.setType(DbColumnType.ARRAY.getType());
                propertyType.setImportT(DbColumnType.ARRAY.getPkg());
                break;
            }
            default: {
                propertyType.setType(DbColumnType.STRING.getType());
                propertyType.setImportT(DbColumnType.STRING.getPkg());
            }
        }
        return propertyType;
    }

    public static boolean isBaseData(String dataType) {
        boolean isBaseData = true;
        if (ToolUtil.isNotEmpty((Object)dataType) && (dataType.equals(OBJECT) || dataType.equals(ARRAY))) {
            isBaseData = false;
        }
        return isBaseData;
    }
}

