/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.datasource.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.speedcode.common.exception.LcdpException;
import com.jxdinfo.speedcode.common.exception.LcdpExceptionEnum;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import com.jxdinfo.speedcode.datasource.config.DataSourceConfig;
import com.jxdinfo.speedcode.datasource.config.querysql.QuerySqlModel;
import com.jxdinfo.speedcode.datasource.model.TableField;
import com.jxdinfo.speedcode.datasource.model.TableInfo;
import com.jxdinfo.speedcode.datasource.service.DataSourceService;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class DataSourceServiceImpl
implements DataSourceService {
    @Override
    public List<TableInfo> getDataSourceInfo(DataSourceConfig dataSourceConfig) throws LcdpException {
        ArrayList<TableInfo> tableInfoList = new ArrayList<TableInfo>();
        ArrayList<TableField> fieldInfo = new ArrayList<TableField>();
        QuerySqlModel querySqlModel = this.getQuerySqlObject(dataSourceConfig);
        if (ToolUtil.isEmpty((Object)querySqlModel)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_SUPPORT_DATA_BASE, dataSourceConfig.getUrl());
        }
        String tableSql = null;
        if (querySqlModel != null) {
            tableSql = querySqlModel.getTableSqlTemplate().replace("${dbName}", dataSourceConfig.getDbName());
        }
        String fieldSql = null;
        if (querySqlModel != null) {
            fieldSql = querySqlModel.getFieldSqlTemplate().replace("${dbName}", dataSourceConfig.getDbName());
        }
        try (Connection connection = dataSourceConfig.initConn();
             PreparedStatement preparedTableStatement = connection.prepareStatement(tableSql);
             PreparedStatement preparedFieldStatement = connection.prepareStatement(fieldSql);
             ResultSet tableResultSet = preparedTableStatement.executeQuery();
             ResultSet fieldResultSet = preparedFieldStatement.executeQuery();){
            this.dealTableResultMap(tableInfoList, tableResultSet);
            this.dealFieldResultMap(fieldInfo, fieldResultSet);
        }
        catch (ClassNotFoundException | SQLException c) {
            c.printStackTrace();
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_DATA_BASE, dataSourceConfig.getDriverName());
        }
        return this.concatColumnsToTablesWithFilter(tableInfoList, fieldInfo);
    }

    private void dealFieldResultMap(List<TableField> fieldInfo, ResultSet fieldResultSet) throws SQLException {
        if (null != fieldResultSet) {
            while (fieldResultSet.next()) {
                TableField tableField = new TableField();
                tableField.setTableName(fieldResultSet.getString(1));
                tableField.setName(fieldResultSet.getString(2));
                tableField.setComment(fieldResultSet.getString(3));
                tableField.setType(fieldResultSet.getString(4));
                tableField.setPrimarys(fieldResultSet.getString(5));
                fieldInfo.add(tableField);
            }
        }
    }

    private void dealTableResultMap(List<TableInfo> tableInfoList, ResultSet tableResultSet) throws SQLException {
        if (null != tableResultSet) {
            while (tableResultSet.next()) {
                TableInfo tableInfo = new TableInfo();
                tableInfo.setName(tableResultSet.getString(1));
                tableInfo.setComment(tableResultSet.getString(2));
                tableInfo.setType(tableResultSet.getString(3));
                tableInfoList.add(tableInfo);
            }
        }
    }

    @Override
    public String defaultDBTypeConfig() {
        InputStream inputStream = this.getClass().getResourceAsStream("/dbType.json");
        return new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining(System.lineSeparator()));
    }

    private QuerySqlModel getQuerySqlObject(DataSourceConfig dataSourceConfig) {
        String url = dataSourceConfig.getUrl();
        if (ToolUtil.isEmpty((Object)url)) {
            return null;
        }
        InputStream inputStream = this.getClass().getResourceAsStream("/tableQuery.json");
        String result = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining(System.lineSeparator()));
        Map querySqlModelMap = (Map)JSON.parseObject((String)result, (TypeReference)new TypeReference<HashMap<String, QuerySqlModel>>(){}, (Feature[])new Feature[0]);
        return (QuerySqlModel)querySqlModelMap.get(dataSourceConfig.getDbTypeCustom());
    }

    private List<TableInfo> concatColumnsToTablesWithFilter(List<TableInfo> tableList, List<TableField> columnList) {
        for (TableField column : columnList) {
            String tableName_col = column.getTableName();
            for (TableInfo table : tableList) {
                String tableName_tab = table.getName();
                if (!tableName_col.equals(tableName_tab)) continue;
                if (null != table.getFields()) {
                    String columnName = column.getName();
                    column.setName(columnName);
                    column.setRealName(columnName);
                    table.getFields().add(column);
                    continue;
                }
                ArrayList<TableField> fieldList = new ArrayList<TableField>();
                String columnName = column.getName();
                column.setName(columnName);
                column.setRealName(columnName);
                fieldList.add(column);
                table.setFields(fieldList);
            }
        }
        return tableList;
    }
}

