/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.datasource.config.rules;

import com.jxdinfo.speedcode.common.util.SpeedCodeStringUtil;

public enum NamingStrategy {
    nochange,
    underline_to_camel;


    public static String underlineToCamel(String name) {
        String[] camels;
        if (SpeedCodeStringUtil.isEmpty((CharSequence)name)) {
            return "";
        }
        String tempName = name;
        if (SpeedCodeStringUtil.isCapitalMode((String)name) || SpeedCodeStringUtil.isMixedMode((String)name)) {
            tempName = name.toLowerCase();
        }
        StringBuilder result = new StringBuilder();
        for (String camel : camels = tempName.split("_")) {
            if (SpeedCodeStringUtil.isEmpty((CharSequence)camel)) continue;
            if (result.length() == 0) {
                result.append(camel);
                continue;
            }
            result.append(NamingStrategy.capitalFirst(camel));
        }
        return result.toString();
    }

    public static String removePrefix(String name, String ... prefix) {
        if (SpeedCodeStringUtil.isEmpty((CharSequence)name)) {
            return "";
        }
        if (null != prefix) {
            for (String pf : prefix) {
                if (!name.toLowerCase().matches("^" + pf.toLowerCase() + ".*")) continue;
                return name.substring(pf.length());
            }
        }
        return name;
    }

    public static boolean isPrefixContained(String name, String ... prefix) {
        if (SpeedCodeStringUtil.isEmpty((CharSequence)name)) {
            return false;
        }
        if (null != prefix) {
            for (String pf : prefix) {
                if (!name.toLowerCase().matches("^" + pf.toLowerCase() + ".*")) continue;
                return true;
            }
        }
        return false;
    }

    public static String removePrefixAndCamel(String name, String[] tablePrefix) {
        return NamingStrategy.underlineToCamel(NamingStrategy.removePrefix(name, tablePrefix));
    }

    public static String capitalFirst(String name) {
        if (SpeedCodeStringUtil.isNotEmpty((CharSequence)name)) {
            return name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        return "";
    }
}

