/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.datasource.config;

import com.jxdinfo.speedcode.common.exception.LcdpException;
import com.jxdinfo.speedcode.common.exception.LcdpExceptionEnum;
import com.jxdinfo.speedcode.datasource.config.ITypeConvert;
import com.jxdinfo.speedcode.datasource.config.rules.DbType;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class DataSourceConfig {
    private String id;
    private DbType dbType;
    private String dbTypeCustom;
    private String schemaname = "public";
    private ITypeConvert typeConvert;
    private String url;
    private String driverName;
    private String username;
    private String password;
    private String dbName;
    private String desc;
    private String name;
    private String version;

    private DbType getDbType() throws LcdpException {
        if (null == this.dbType) {
            if (this.driverName.toLowerCase().contains("mysql")) {
                this.dbType = DbType.MYSQL;
            } else if (this.driverName.toLowerCase().contains("oracle")) {
                this.dbType = DbType.ORACLE;
            } else if (this.driverName.toLowerCase().contains("postgresql")) {
                this.dbType = DbType.POSTGRE_SQL;
            } else if (this.driverName.toLowerCase().contains("dm")) {
                this.dbType = DbType.DM;
            } else if (this.driverName.toLowerCase().contains("oscar")) {
                this.dbType = DbType.OSCAR;
            } else {
                throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_DATA_BASE, this.driverName);
            }
        }
        return this.dbType;
    }

    public void setDbType(DbType dbType) {
        this.dbType = dbType;
    }

    public String getSchemaname() {
        return this.schemaname;
    }

    public void setSchemaname(String schemaname) {
        this.schemaname = schemaname;
    }

    public void setTypeConvert(ITypeConvert typeConvert) {
        this.typeConvert = typeConvert;
    }

    public Connection initConn() throws ClassNotFoundException, SQLException {
        Class.forName(this.driverName);
        return DriverManager.getConnection(this.url, this.username, this.password);
    }

    public String getDbTypeCustom() {
        return this.dbTypeCustom;
    }

    public void setDbTypeCustom(String dbTypeCustom) {
        this.dbTypeCustom = dbTypeCustom;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

