/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.codegenerator.core.publish.controller;

import com.jxdinfo.speedcode.codegenerator.core.publish.service.WorkFlowPublishService;
import com.jxdinfo.speedcode.common.exception.LcdpException;
import com.jxdinfo.speedcode.common.exception.LcdpExceptionEnum;
import com.jxdinfo.speedcode.common.response.SpeedCodeResponse;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/speedcode/publish"})
public class WorkFlowPublishController {
    private final WorkFlowPublishService workFlowPublishService;

    @Autowired
    public WorkFlowPublishController(WorkFlowPublishService workFlowPublishService) {
        this.workFlowPublishService = workFlowPublishService;
    }

    @RequestMapping(value={"/workflow"})
    public SpeedCodeResponse<?> workflowPublish(String id) {
        SpeedCodeResponse<Object> speedCodeResponse = new SpeedCodeResponse<Object>();
        try {
            speedCodeResponse = this.workFlowPublishService.publish(id);
        }
        catch (IOException e) {
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_ERROR.getCode());
            e.printStackTrace();
        }
        catch (LcdpException e) {
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_ERROR.getCode());
            e.printInfo();
        }
        return speedCodeResponse;
    }
}

