/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.codegenerator.core.publish.controller;

import com.jxdinfo.speedcode.codegenerator.core.publish.model.DataBaseTestMessagesDto;
import com.jxdinfo.speedcode.codegenerator.core.publish.model.Datasource;
import com.jxdinfo.speedcode.codegenerator.core.publish.model.DatasourceConfigDTO;
import com.jxdinfo.speedcode.codegenerator.core.publish.model.MethodType;
import com.jxdinfo.speedcode.codegenerator.core.publish.service.DatasourceDataService;
import com.jxdinfo.speedcode.codegenerator.core.publish.util.sqlTestUtil.DoConnection;
import com.jxdinfo.speedcode.common.exception.LcdpException;
import com.jxdinfo.speedcode.common.exception.LcdpExceptionEnum;
import com.jxdinfo.speedcode.common.response.SpeedCodeResponse;
import com.jxdinfo.speedcode.datasource.model.TableInfo;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/speedcode/databaseData"})
public class DatabaseDataController {
    private final DatasourceDataService datasourceDataService;

    @Autowired
    public DatabaseDataController(DatasourceDataService datasourceDataService) {
        this.datasourceDataService = datasourceDataService;
    }

    @PostMapping(value={""})
    public SpeedCodeResponse<Void> save(DatasourceConfigDTO configDTO) {
        SpeedCodeResponse speedCodeResponse = new SpeedCodeResponse();
        try {
            this.datasourceDataService.save(configDTO);
        }
        catch (IOException e) {
            e.printStackTrace();
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_ERROR.getCode());
            speedCodeResponse.setErrorMsg(LcdpExceptionEnum.FILE_ERROR.getMsg());
        }
        speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_DONE.getCode());
        return speedCodeResponse;
    }

    @DeleteMapping(value={""})
    public SpeedCodeResponse<Void> delete(String id) {
        SpeedCodeResponse speedCodeResponse = new SpeedCodeResponse();
        try {
            this.datasourceDataService.delete(id);
        }
        catch (IOException e) {
            speedCodeResponse.setErrorMsg(LcdpExceptionEnum.FILE_ERROR.getMsg());
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_ERROR.getCode());
            e.printStackTrace();
        }
        speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_DONE.getCode());
        return speedCodeResponse;
    }

    @PutMapping(value={""})
    public SpeedCodeResponse<Void> update(DatasourceConfigDTO configDTO) {
        SpeedCodeResponse speedCodeResponse = new SpeedCodeResponse();
        try {
            this.datasourceDataService.update(configDTO);
        }
        catch (IOException e) {
            speedCodeResponse.setErrorMsg(LcdpExceptionEnum.FILE_ERROR.getMsg());
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_ERROR.getCode());
            e.printStackTrace();
        }
        speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_DONE.getCode());
        return speedCodeResponse;
    }

    @GetMapping(value={"/tableInfo/{id}"})
    public SpeedCodeResponse<List<TableInfo>> getTableInfoById(@PathVariable String id) {
        SpeedCodeResponse speedCodeResponse = new SpeedCodeResponse();
        try {
            speedCodeResponse.setData(this.datasourceDataService.getTableInfoById(id));
        }
        catch (IOException e) {
            speedCodeResponse.setErrorMsg(LcdpExceptionEnum.FILE_ERROR.getMsg());
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_ERROR.getCode());
            e.printStackTrace();
        }
        catch (LcdpException e) {
            e.printStackTrace();
        }
        speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_DONE.getCode());
        return speedCodeResponse;
    }

    @GetMapping(value={"/{id}"})
    public SpeedCodeResponse<DatasourceConfigDTO> get(@PathVariable String id) {
        SpeedCodeResponse speedCodeResponse = new SpeedCodeResponse();
        try {
            speedCodeResponse.setData((Object)this.datasourceDataService.getById(id));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_DONE.getCode());
        return speedCodeResponse;
    }

    @GetMapping(value={"/tree"})
    public SpeedCodeResponse<Map<String, DatasourceConfigDTO>> getTree() {
        SpeedCodeResponse response = new SpeedCodeResponse();
        try {
            response.setData(this.datasourceDataService.getTree());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        response.setErrorCode(LcdpExceptionEnum.FILE_DONE.getCode());
        return response;
    }

    @GetMapping(value={"/list"})
    public SpeedCodeResponse<List<DatasourceConfigDTO>> getList() {
        SpeedCodeResponse response = new SpeedCodeResponse();
        try {
            response.setData(this.datasourceDataService.getList());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        response.setErrorCode(LcdpExceptionEnum.FILE_DONE.getCode());
        return response;
    }

    @GetMapping(value={"/type"})
    public SpeedCodeResponse<List<MethodType>> getType() {
        SpeedCodeResponse res = new SpeedCodeResponse();
        try {
            List<MethodType> methodTypes = this.datasourceDataService.getMethodTypes();
            res.setData(methodTypes);
            res.setErrorCode(LcdpExceptionEnum.FILE_DONE.getCode());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return res;
    }

    @DeleteMapping(value={"/clear"})
    public SpeedCodeResponse<Boolean> clear() {
        SpeedCodeResponse res = new SpeedCodeResponse();
        boolean clearResult = this.datasourceDataService.clear();
        res.setData((Object)clearResult);
        return res;
    }

    @GetMapping(value={"/isEmpty"})
    public SpeedCodeResponse<Boolean> isEmpty() {
        SpeedCodeResponse speedCodeResponse = new SpeedCodeResponse();
        speedCodeResponse.setData((Object)this.datasourceDataService.isEmpty());
        return speedCodeResponse;
    }

    @GetMapping(value={"/default"})
    public SpeedCodeResponse<HashMap<String, Object>> getDefaultSource() {
        SpeedCodeResponse response = new SpeedCodeResponse();
        try {
            response.setData(this.datasourceDataService.getDefaultSource());
            response.setErrorCode(200);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return response;
    }

    @GetMapping(value={"/datasource"})
    public SpeedCodeResponse<Map<String, Datasource>> getOperationTypes() throws IOException {
        SpeedCodeResponse response = new SpeedCodeResponse();
        response.setData(this.datasourceDataService.getConnTypeConfigMap());
        response.setErrorCode(LcdpExceptionEnum.FILE_DONE.getCode());
        return response;
    }

    @PostMapping(value={"/dataBase/test"})
    public DataBaseTestMessagesDto postJsonDataBaseTest(@RequestBody DatasourceConfigDTO configDTO) {
        DataBaseTestMessagesDto dataBaseTestMessagesDto = DoConnection.connection(configDTO);
        return dataBaseTestMessagesDto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/API/test"})
    public Map postJsonApiTest(@RequestBody Map<String, String> urlMap) {
        HashMap<String, String> map;
        block14: {
            map = new HashMap<String, String>();
            String url = urlMap.get("url");
            Socket s = new Socket();
            try {
                if (url != null && url.lastIndexOf(":") > 0) {
                    url = url.toLowerCase().replaceFirst("http://", "");
                    String urlStr = url.substring(0, url.lastIndexOf(":"));
                    int port = Integer.parseInt(url.substring(url.lastIndexOf(":") + 1));
                    try {
                        InetSocketAddress add = new InetSocketAddress(urlStr, port);
                        s.connect(add, 3000);
                        map.put("success", "\u6d4b\u8bd5\u6210\u529f\uff01");
                        break block14;
                    }
                    catch (Exception e) {
                        map.put("error", "\u8fde\u63a5\u5931\u8d25\uff01");
                        break block14;
                    }
                    finally {
                        try {
                            s.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                map.put("error", "\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
            catch (Exception e) {
                map.put("error", "\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
        }
        return map;
    }
}

