/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.codegenerator.core.publish.controller;

import com.jxdinfo.speedcode.codegenerator.core.publish.service.BackPublishService;
import com.jxdinfo.speedcode.codegenerator.core.publish.service.PublishService;
import com.jxdinfo.speedcode.common.exception.LcdpException;
import com.jxdinfo.speedcode.common.exception.LcdpExceptionEnum;
import com.jxdinfo.speedcode.common.model.publish.GenCodeResult;
import com.jxdinfo.speedcode.common.response.SpeedCodeResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/speedcode/back/publish"})
public class BackPublishController {
    private final BackPublishService backPublishService;
    private final PublishService publishService;

    @Autowired
    public BackPublishController(BackPublishService backPublishService, PublishService publishService) {
        this.backPublishService = backPublishService;
        this.publishService = publishService;
    }

    @RequestMapping(value={"/dataModel"})
    public SpeedCodeResponse<List<GenCodeResult>> publishDataModel(@RequestBody Map<String, String> param) throws IOException, LcdpException {
        SpeedCodeResponse genCodeResultSpeedCodeResponse = new SpeedCodeResponse();
        List<GenCodeResult> backCodeResult = this.backPublishService.publishBackCode(param);
        genCodeResultSpeedCodeResponse.setData(backCodeResult);
        return genCodeResultSpeedCodeResponse;
    }

    @GetMapping(value={"/xml"})
    public SpeedCodeResponse<List<String>> getXmlFileCode(@RequestParam String dataModelId, @RequestParam String operationId) throws IOException, LcdpException {
        SpeedCodeResponse response = new SpeedCodeResponse();
        response.setData(this.backPublishService.getXmlCode(dataModelId, operationId));
        response.setErrorCode(LcdpExceptionEnum.FILE_DONE.getCode());
        return response;
    }
}

