/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.codegenerator.core.publish.controller;

import com.jxdinfo.speedcode.codegenerator.core.publish.service.BackPublishService;
import com.jxdinfo.speedcode.codegenerator.core.publish.service.PublishService;
import com.jxdinfo.speedcode.common.exception.LcdpException;
import com.jxdinfo.speedcode.common.model.publish.GenCodeResult;
import com.jxdinfo.speedcode.common.response.SpeedCodeResponse;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/speedcode/back/publish"})
public class BackPublishController {
    private final BackPublishService backPublishService;
    private final PublishService publishService;

    @Autowired
    public BackPublishController(BackPublishService backPublishService, PublishService publishService) {
        this.backPublishService = backPublishService;
        this.publishService = publishService;
    }

    @RequestMapping(value={"/dataModel"})
    public SpeedCodeResponse<List<GenCodeResult>> publishDataModel(String id) throws IOException, LcdpException {
        SpeedCodeResponse genCodeResultSpeedCodeResponse = new SpeedCodeResponse();
        List<GenCodeResult> backCodeResult = this.backPublishService.publishBackCode(id);
        List<GenCodeResult> pageResult = this.publishService.modelWebVue(id);
        if (ToolUtil.isNotEmpty(pageResult)) {
            backCodeResult.addAll(pageResult);
        }
        genCodeResultSpeedCodeResponse.setData(backCodeResult);
        return genCodeResultSpeedCodeResponse;
    }
}

