/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.codegenerator.core.publish.controller;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.speedcode.codegenerator.core.generate.style.StyleScheme;
import com.jxdinfo.speedcode.codegenerator.core.publish.service.StyleSchemeService;
import com.jxdinfo.speedcode.common.exception.LcdpException;
import com.jxdinfo.speedcode.common.exception.LcdpExceptionEnum;
import com.jxdinfo.speedcode.common.response.SpeedCodeResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/speedcode/styleScheme"})
public class StyleSchemeController {
    private final StyleSchemeService styleSchemeService;

    @Autowired
    public StyleSchemeController(StyleSchemeService styleSchemeService) {
        this.styleSchemeService = styleSchemeService;
    }

    @PostMapping(value={""})
    public SpeedCodeResponse<Void> save(@RequestBody JSONObject styleScheme) {
        SpeedCodeResponse speedCodeResponse = new SpeedCodeResponse();
        try {
            this.styleSchemeService.saveOrUpdate(styleScheme);
            if (styleScheme.get((Object)"isApply").equals(true)) {
                this.styleSchemeService.styleApply(Convert.toStr((Object)styleScheme.get((Object)"name")), "web");
                this.styleSchemeService.styleApply(Convert.toStr((Object)styleScheme.get((Object)"name")), "mobile");
            }
        }
        catch (IOException e) {
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_WRITE_FAIL.getCode());
            speedCodeResponse.setErrorMsg(LcdpExceptionEnum.FILE_WRITE_FAIL.getMsg());
        }
        return speedCodeResponse;
    }

    @DeleteMapping(value={"/{name}"})
    public SpeedCodeResponse<Void> delete(@PathVariable String name) {
        SpeedCodeResponse speedCodeResponse = new SpeedCodeResponse();
        try {
            this.styleSchemeService.delete(name);
        }
        catch (IOException e) {
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_DELETE_FAIL.getCode());
            speedCodeResponse.setErrorMsg(LcdpExceptionEnum.FILE_DELETE_FAIL.getMsg());
        }
        return speedCodeResponse;
    }

    @PutMapping(value={""})
    public SpeedCodeResponse<Void> update(StyleScheme styleSchemeDTO) {
        SpeedCodeResponse speedCodeResponse = new SpeedCodeResponse();
        this.styleSchemeService.update(styleSchemeDTO);
        return speedCodeResponse;
    }

    @GetMapping(value={"/list"})
    public SpeedCodeResponse<List<JSONObject>> list() {
        SpeedCodeResponse speedCodeResponse = new SpeedCodeResponse();
        try {
            List<JSONObject> styleSchemeDTOList = this.styleSchemeService.getList();
            speedCodeResponse.setData(styleSchemeDTOList);
        }
        catch (IOException e) {
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_READ_FAIL.getCode());
            speedCodeResponse.setErrorMsg(LcdpExceptionEnum.FILE_READ_FAIL.getMsg());
        }
        return speedCodeResponse;
    }

    @GetMapping(value={"/tree"})
    public SpeedCodeResponse<Map<String, StyleScheme>> tree() {
        SpeedCodeResponse speedCodeResponse = new SpeedCodeResponse();
        Map<String, StyleScheme> styleSchemeDTOMap = this.styleSchemeService.getTree();
        speedCodeResponse.setData(styleSchemeDTOMap);
        return speedCodeResponse;
    }

    @PostMapping(value={"/publish/{name}"})
    public SpeedCodeResponse<Void> publish(@PathVariable String name) throws LcdpException {
        SpeedCodeResponse speedCodeResponse = new SpeedCodeResponse();
        try {
            this.styleSchemeService.publish(name);
        }
        catch (IOException e) {
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_WRITE_FAIL.getCode());
            speedCodeResponse.setErrorMsg(LcdpExceptionEnum.FILE_WRITE_FAIL.getMsg());
            e.printStackTrace();
        }
        return speedCodeResponse;
    }

    @PostMapping(value={"/application/{name}"})
    public SpeedCodeResponse<Boolean> styleApply(@PathVariable String name) throws LcdpException {
        this.styleSchemeService.styleApply(name, "web");
        this.styleSchemeService.styleApply(name, "mobile");
        this.styleSchemeService.importDefault();
        SpeedCodeResponse response = new SpeedCodeResponse();
        response.setData((Object)true);
        return response;
    }
}

