/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.codegenerator.core.publish.controller;

import com.jxdinfo.hussar.config.datasource.DataSourceUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.engine.DefinitionEngineService;
import com.jxdinfo.speedcode.auth.FormDesignUser;
import com.jxdinfo.speedcode.codegenerator.core.publish.service.WorkFlowPublishService;
import com.jxdinfo.speedcode.collaboration.lock.model.StorageLockPO;
import com.jxdinfo.speedcode.collaboration.lock.service.IndexStorageLockService;
import com.jxdinfo.speedcode.common.auth.UserKit;
import com.jxdinfo.speedcode.common.exception.LcdpException;
import com.jxdinfo.speedcode.common.exception.LcdpExceptionEnum;
import com.jxdinfo.speedcode.common.model.BaseFile;
import com.jxdinfo.speedcode.common.model.WorkflowInfo;
import com.jxdinfo.speedcode.common.properties.SpeedCodeProperties;
import com.jxdinfo.speedcode.common.response.SpeedCodeResponse;
import com.jxdinfo.speedcode.common.util.GetAppInfoUtil;
import com.jxdinfo.speedcode.file.fileoperate.service.WorkflowService;
import com.jxdinfo.speedcode.storage.common.model.StorageResult;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class WorkFlowPublishController {
    private final WorkFlowPublishService workFlowPublishService;
    private final SpeedCodeProperties speedCodeProperties;
    private final IndexStorageLockService indexStorageLockService;
    private final WorkflowService workflowService;
    private static final String APP_ID = "appId";

    @Autowired
    public WorkFlowPublishController(WorkFlowPublishService workFlowPublishService, SpeedCodeProperties speedCodeProperties, IndexStorageLockService indexStorageLockService, WorkflowService workflowService) {
        this.workFlowPublishService = workFlowPublishService;
        this.speedCodeProperties = speedCodeProperties;
        this.indexStorageLockService = indexStorageLockService;
        this.workflowService = workflowService;
    }

    @RequestMapping(value={"/speedcode/publish/workflow"})
    public SpeedCodeResponse<?> workflowPublish(@RequestParam String id, HttpServletRequest request) {
        SpeedCodeResponse<Object> speedCodeResponse = new SpeedCodeResponse<Object>();
        try {
            speedCodeResponse = this.workFlowPublishService.publish(id, request.getHeader(APP_ID));
            speedCodeResponse.setErrorCode(HttpStatus.OK.value());
        }
        catch (IOException e) {
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_ERROR.getCode());
            e.printStackTrace();
        }
        catch (LcdpException e) {
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_ERROR.getCode());
            e.printInfo();
        }
        return speedCodeResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PutMapping(value={"/speed/workflowinfo/adjustProcess"})
    public SpeedCodeResponse<Object> adjustProcess(@RequestBody WorkflowInfo workflowInfo, HttpServletRequest request) throws IOException, LcdpException {
        boolean flag;
        SpeedCodeResponse sharedStorage;
        if (this.speedCodeProperties.getScenes().isSharedStorage() && (sharedStorage = this.isSharedStorage(workflowInfo.getModelId())).getErrorCode() != 200) {
            return sharedStorage;
        }
        boolean isChangeMaster = GetAppInfoUtil.getApplicationType();
        try {
            if (isChangeMaster) {
                DataSourceUtil.changeTempDs((String)"master");
            }
            flag = DefinitionEngineService.queryIsPublish((String)workflowInfo.getIdentity());
        }
        finally {
            if (isChangeMaster) {
                DataSourceUtil.poll();
            }
        }
        if (ToolUtil.isNotEmpty((Object)workflowInfo.getData())) {
            if (!flag) {
                SpeedCodeResponse<Object> speedCodeResponse = new SpeedCodeResponse<Object>();
                try {
                    speedCodeResponse = this.workFlowPublishService.publish(workflowInfo.getId(), request.getHeader(APP_ID));
                }
                catch (IOException e) {
                    speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_ERROR.getCode());
                    e.printStackTrace();
                }
                catch (LcdpException e) {
                    speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_ERROR.getCode());
                    e.printInfo();
                }
                return speedCodeResponse;
            }
            return this.workflowService.adjustProcess(workflowInfo, request.getHeader(APP_ID));
        }
        this.workflowService.updateFileMeta((BaseFile)workflowInfo);
        return new SpeedCodeResponse();
    }

    private SpeedCodeResponse isSharedStorage(String id) {
        String userId;
        StorageResult result;
        FormDesignUser user = null;
        try {
            user = UserKit.getUser();
        }
        catch (Exception exception) {
            // empty catch block
        }
        SpeedCodeResponse speedCodeResponse = new SpeedCodeResponse();
        if (com.jxdinfo.speedcode.common.util.ToolUtil.isEmpty((Object)user)) {
            speedCodeResponse.setErrorCode(400);
            speedCodeResponse.setErrorMsg("\u8bf7\u5148\u767b\u5f55");
            return speedCodeResponse;
        }
        if (this.speedCodeProperties.isLockEnabled() && com.jxdinfo.speedcode.common.util.ToolUtil.isNotEmpty((Object)(result = this.indexStorageLockService.getOneLockByResource(id)).getData()) && (!com.jxdinfo.speedcode.common.util.ToolUtil.isNotEmpty((Object)(userId = ((StorageLockPO)result.getData()).getUserId())) || !userId.equals(user.getId()))) {
            speedCodeResponse.setErrorCode(403);
            speedCodeResponse.setErrorMsg(((StorageLockPO)result.getData()).getUserName() + "\u6b63\u5728\u5360\u7528");
            return speedCodeResponse;
        }
        return new SpeedCodeResponse();
    }
}

