import Vue from 'vue'
import XEUtils from 'xe-utils';
import VXETable from 'vxe-table';
import 'vxe-table/lib/index.css';
import 'normalize.css/normalize.css' // A modern alternative to CSS resets
import 'BpmShowWorkflow/dist/BpmShowWorkflow.css';
import sessionSync from 'sync-session-storage'
import ElementUI from 'element-ui'
import '@/styles/element-variables.scss'
import locale from 'element-ui/lib/locale/lang/zh-CN' // lang i18n
import '@/styles/index.scss' // global css
// import '@/assets/css/lcdp_axe_ele.scss' // 表单设计器生成组件需要的样式覆盖
// import '@/assets/css/lcdp_axe_ionic.scss' // 表单设计器生成组件需要的样式覆盖
import numeral from 'numeral';
import moment from 'moment';
import App from '@/pages/index/${vuePath}.vue'
import store from '@/pages/index/store'
// 单页面不需要动态路由
import { constantRouterMap } from '@/pages/index/router/index'
store.registerModule('permission', {
    state: {
        routers: constantRouterMap,
        addRouters: [],
        theRouters: [{ path: '*', redirect: '/404', hidden: true }],
    },
    actions: {
        GenerateMenu({ commit }) { return Promise.resolve() },
        GenerateRoutes({ commit }) { return Promise.resolve() },
    },
})
import router from '@/pages/index/router/index'
import '@/icons' // icon
import '@/pages/index/permission' // permission control

import _ from 'lodash';
import '@/directives/drag_dialog'
import '@/utils/tokenTranser'
import permission from '@/pages/index/store/permission'
import i18n from '@/i18n/index'
import '@/pages/index/custom'
import accountingNumFormat from '@/utils/accountingNumFormat'
Vue.use(ElementUI, { locale });
import { flowchartApi } from 'BpmShowWorkflow';
import de from "element-ui/src/locale/lang/de";
import echarts from 'echarts';
import '@/assets/font/lcdpFont/iconfont.css'
Vue.prototype.$echarts = echarts;
flowchartApi.setPrefix(process.env.VUE_APP_HUSSAR_DEFAULT_API);
Vue.use(VXETable);
Vue.prototype.$accountingNumFormat = accountingNumFormat;
Vue.prototype.$numeral = numeral;
Vue.prototype.$moment = moment;
Vue.prototype.$lodash = _;
Vue.prototype.$utils = XEUtils;
Vue.prototype.$cookie = XEUtils.cookie;
// Vue.prototype.$jsEncrypt = JsEncrypt
Vue.config.productionTip = false;
import vClickOutside from 'v-click-outside'
Vue.use(vClickOutside);
Vue.prototype.$permission = permission;
// 给 vue 实例挂载全局窗口对象，属性名称随意定义，例如：$XModal
Vue.prototype.$modal = VXETable.modal;
Vue.prototype.$bpm_t = (key, value) => i18n.t(key, value);
new Vue({
    i18n,
    router,
    store: store,
    render: h => h(App)
}).$mount('#app');
window.vm = new Vue({ i18n: i18n });
//登录后在多个标签页同步sessionStorage
sessionSync.init({flag:'hussar'})
sessionSync.trigger()
//同步之后加载页面样式
sessionSync.afterSync(function (){
    window.document.documentElement.setAttribute('data-theme',sessionStorage.getItem('HussarTheme'))
})
