/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.codegenerator.core.publish.controller;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.speedcode.codegenerator.core.generate.style.StyleScheme;
import com.jxdinfo.speedcode.codegenerator.core.publish.service.StyleSchemeService;
import com.jxdinfo.speedcode.common.exception.LcdpException;
import com.jxdinfo.speedcode.common.exception.LcdpExceptionEnum;
import com.jxdinfo.speedcode.common.properties.SpeedCodeProperties;
import com.jxdinfo.speedcode.common.response.SpeedCodeResponse;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/speedcode/styleScheme"})
public class StyleSchemeController {
    private final StyleSchemeService styleSchemeService;
    private final SpeedCodeProperties speedCodeProperties;

    @Autowired
    public StyleSchemeController(StyleSchemeService styleSchemeService, SpeedCodeProperties speedCodeProperties) {
        this.styleSchemeService = styleSchemeService;
        this.speedCodeProperties = speedCodeProperties;
    }

    @PostMapping(value={"/add"})
    public SpeedCodeResponse<Void> save(@RequestBody StyleScheme styleScheme) {
        SpeedCodeResponse speedCodeResponse = new SpeedCodeResponse();
        try {
            this.styleSchemeService.saveOrUpdate(styleScheme);
            if (styleScheme.getIsApply()) {
                this.styleSchemeService.styleApply(styleScheme.getName(), "web");
                this.styleSchemeService.styleApply(styleScheme.getName(), "mobile");
            }
        }
        catch (IOException e) {
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_WRITE_FAIL.getCode());
            speedCodeResponse.setErrorMsg(LcdpExceptionEnum.FILE_WRITE_FAIL.getMsg());
        }
        return speedCodeResponse;
    }

    @PostMapping(value={"/del/{name}"})
    public SpeedCodeResponse<Void> delete(@PathVariable String name) {
        SpeedCodeResponse speedCodeResponse = new SpeedCodeResponse();
        try {
            this.styleSchemeService.delete(name);
        }
        catch (IOException e) {
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_DELETE_FAIL.getCode());
            speedCodeResponse.setErrorMsg(LcdpExceptionEnum.FILE_DELETE_FAIL.getMsg());
        }
        return speedCodeResponse;
    }

    @GetMapping(value={"/list"})
    public SpeedCodeResponse<List<JSONObject>> list() {
        SpeedCodeResponse speedCodeResponse = new SpeedCodeResponse();
        try {
            List<JSONObject> styleSchemeDTOList = this.styleSchemeService.getList();
            speedCodeResponse.setData(styleSchemeDTOList);
        }
        catch (IOException e) {
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_READ_FAIL.getCode());
            speedCodeResponse.setErrorMsg(LcdpExceptionEnum.FILE_READ_FAIL.getMsg());
        }
        return speedCodeResponse;
    }

    @PostMapping(value={"/publish/{name}"})
    public SpeedCodeResponse<Void> publish(@PathVariable String name) throws LcdpException {
        SpeedCodeResponse speedCodeResponse = new SpeedCodeResponse();
        try {
            this.styleSchemeService.publish(name);
        }
        catch (IOException e) {
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_WRITE_FAIL.getCode());
            speedCodeResponse.setErrorMsg(LcdpExceptionEnum.FILE_WRITE_FAIL.getMsg());
            e.printStackTrace();
        }
        return speedCodeResponse;
    }

    @PostMapping(value={"/application/{name}"})
    public SpeedCodeResponse<Boolean> styleApply(@PathVariable String name) throws LcdpException {
        this.styleSchemeService.styleApply(name, "web");
        this.styleSchemeService.styleApply(name, "mobile");
        this.styleSchemeService.importDefault();
        SpeedCodeResponse response = new SpeedCodeResponse();
        response.setData((Object)true);
        return response;
    }

    @PostMapping(value={"/web"})
    public SpeedCodeResponse<Void> saveWebPartially(@RequestBody StyleScheme styleScheme) {
        SpeedCodeResponse speedCodeResponse = new SpeedCodeResponse();
        try {
            this.styleSchemeService.updateWebPartially(styleScheme);
            if (styleScheme.getIsApply()) {
                this.styleSchemeService.styleApply(styleScheme.getName(), "web");
            }
        }
        catch (IOException e) {
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_WRITE_FAIL.getCode());
            speedCodeResponse.setErrorMsg(LcdpExceptionEnum.FILE_WRITE_FAIL.getMsg());
        }
        return speedCodeResponse;
    }

    @PostMapping(value={"/mobile"})
    public SpeedCodeResponse<Void> saveMobilePartially(@RequestBody StyleScheme styleScheme) {
        SpeedCodeResponse speedCodeResponse = new SpeedCodeResponse();
        try {
            this.styleSchemeService.updateMobilePartially(styleScheme);
            if (styleScheme.getIsApply()) {
                this.styleSchemeService.styleApply(styleScheme.getName(), "mobile");
            }
        }
        catch (IOException e) {
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_WRITE_FAIL.getCode());
            speedCodeResponse.setErrorMsg(LcdpExceptionEnum.FILE_WRITE_FAIL.getMsg());
        }
        return speedCodeResponse;
    }

    @GetMapping(value={"/openCommonCss"})
    public SpeedCodeResponse<String> getOpenCommonCss() {
        SpeedCodeResponse speedCodeResponse = new SpeedCodeResponse();
        speedCodeResponse.setData((Object)this.speedCodeProperties.getOpenCommonCss());
        speedCodeResponse.setErrorCode(LcdpExceptionEnum.SUCCESS.getCode());
        return speedCodeResponse;
    }
}

