/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.codegenerator.core.publish.controller;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.engine.metadata.exception.EngineException;
import com.jxdinfo.speedcode.app.FormDesignAppInfo;
import com.jxdinfo.speedcode.codegenerator.core.publish.model.ExportParamVO;
import com.jxdinfo.speedcode.codegenerator.core.publish.service.ExportService;
import com.jxdinfo.speedcode.common.exception.LcdpException;
import com.jxdinfo.speedcode.common.response.SpeedCodeResponse;
import com.jxdinfo.speedcode.common.util.AppContextUtil;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/speed/resources"})
public class ExportController {
    private final ExportService exportService;

    @Autowired
    public ExportController(ExportService exportService) {
        this.exportService = exportService;
    }

    @GetMapping
    public SpeedCodeResponse<Map<String, List<JSONObject>>> resourceTree(@RequestParam(required=false) String appId) {
        SpeedCodeResponse response = new SpeedCodeResponse();
        try {
            response.setData(this.exportService.resourceTree(appId));
        }
        catch (EngineException | LcdpException | IOException e) {
            e.printStackTrace();
        }
        return response;
    }

    @PostMapping
    public void getJavaFile(ExportParamVO exportParamVO, HttpServletResponse response) {
        try {
            this.exportService.export(exportParamVO, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"/offline"})
    public void exportOfflineToOffline(ExportParamVO exportParamVO, HttpServletResponse response) {
        try {
            this.exportService.exportOffline(exportParamVO, response);
        }
        catch (Exception e) {
            e.printStackTrace();
            try (ServletOutputStream outputStream = response.getOutputStream();){
                response.setStatus(500);
                outputStream.write(0);
                outputStream.flush();
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
        }
    }

    @GetMapping(value={"/axe"})
    public void export(@RequestParam String id, @RequestParam String type, HttpServletResponse response) {
        try {
            this.exportService.export(id, type, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @GetMapping(value={"/appName"})
    public SpeedCodeResponse<String> appName() {
        SpeedCodeResponse response = new SpeedCodeResponse();
        String appName = Optional.ofNullable(AppContextUtil.getAppInfo()).orElseGet(FormDesignAppInfo::new).getEnglishName();
        if (ToolUtil.isEmpty((Object)appName)) {
            response.setData((Object)"");
            response.setErrorCode(-1);
            response.setErrorMsg("\u83b7\u53d6\u5e94\u7528\u4fe1\u606f\u5931\u8d25");
        } else {
            response.setData((Object)appName);
            response.setErrorCode(HttpStatus.OK.value());
        }
        return response;
    }

    @PostMapping(value={"replaceDataSourceType"})
    public void replaceDataSourceType(@RequestBody Map<String, String> param) {
        try {
            this.exportService.replaceDataSourceType(param);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

