/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.codegenerator.core.publish.controller;

import cn.hutool.core.convert.Convert;
import com.jxdinfo.hussar.license.HardwareInfo;
import com.jxdinfo.speedcode.codegenerator.core.generate.dto.DefaultStyleDTO;
import com.jxdinfo.speedcode.codegenerator.core.publish.service.PublishService;
import com.jxdinfo.speedcode.codegenerator.core.publish.service.StyleSchemeService;
import com.jxdinfo.speedcode.common.annotation.ExceptionCatcher;
import com.jxdinfo.speedcode.common.exception.LcdpException;
import com.jxdinfo.speedcode.common.exception.LcdpExceptionEnum;
import com.jxdinfo.speedcode.common.model.publish.GenCodeResult;
import com.jxdinfo.speedcode.common.properties.SpeedCodeProperties;
import com.jxdinfo.speedcode.common.response.SpeedCodeResponse;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/speedcode/publish"})
public class PublishController {
    private final PublishService publishService;
    private final StyleSchemeService styleSchemeService;
    private final SpeedCodeProperties speedCodeProperties;

    @Autowired
    public PublishController(PublishService publishService, StyleSchemeService styleSchemeService, SpeedCodeProperties speedCodeProperties) {
        this.publishService = publishService;
        this.styleSchemeService = styleSchemeService;
        this.speedCodeProperties = speedCodeProperties;
    }

    @RequestMapping(value={"/vue"})
    public SpeedCodeResponse<List<GenCodeResult>> vue(@RequestParam String id) {
        SpeedCodeResponse speedCodeResponse = new SpeedCodeResponse();
        try {
            Integer strategy = HardwareInfo.getLicenseType() == 1 || this.speedCodeProperties.isLocalUnReset() ? Integer.valueOf(3) : null;
            speedCodeResponse.setData(this.publishService.webVue(id, strategy));
            speedCodeResponse.setErrorCode(HttpStatus.OK.value());
            System.gc();
        }
        catch (IOException e) {
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_ERROR.getCode());
            e.printStackTrace();
        }
        catch (LcdpException e) {
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_ERROR.getCode());
            speedCodeResponse.setErrorMsg(e.getMessage());
            e.printInfo();
        }
        return speedCodeResponse;
    }

    @RequestMapping(value={"/mobile"})
    public SpeedCodeResponse<List<GenCodeResult>> mobile(@RequestParam String id) {
        SpeedCodeResponse speedCodeResponse = new SpeedCodeResponse();
        try {
            Integer strategy = HardwareInfo.getLicenseType() == 1 || this.speedCodeProperties.isLocalUnReset() || this.speedCodeProperties.isOfflineLr() ? Integer.valueOf(3) : null;
            speedCodeResponse.setData(this.publishService.mobileVue(id, strategy));
        }
        catch (IOException e) {
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_ERROR.getCode());
            e.printStackTrace();
        }
        catch (LcdpException e) {
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_ERROR.getCode());
            e.printInfo();
        }
        return speedCodeResponse;
    }

    @PostMapping(value={"/styleDefaultValue"})
    @ExceptionCatcher
    public SpeedCodeResponse<Boolean> styleDefaultValue(@RequestBody DefaultStyleDTO defaultStyleDTO) {
        SpeedCodeResponse speedCodeResponse = new SpeedCodeResponse();
        try {
            this.publishService.defaultStyleGenerate(defaultStyleDTO);
            this.styleSchemeService.importDefault();
        }
        catch (LcdpException | IOException e) {
            speedCodeResponse.setErrorCode(40001);
            e.printStackTrace();
        }
        return speedCodeResponse;
    }

    @PostMapping(value={"/writeMergeCode"})
    public SpeedCodeResponse<Void> writeMergeCode(@RequestBody List<GenCodeResult> genCodeResults) throws IOException {
        this.publishService.writeMergeCode(genCodeResults);
        return new SpeedCodeResponse();
    }

    @RequestMapping(value={"/menu/{id}"})
    public SpeedCodeResponse<String> saveMenu(@PathVariable String id, @RequestParam String isSet) throws LcdpException, IOException {
        SpeedCodeResponse response = new SpeedCodeResponse();
        if (Convert.toBool((Object)isSet).booleanValue()) {
            this.publishService.createAndShowMenu(id);
            response.setErrorCode(200);
            response.setErrorMsg("\u914d\u7f6e\u83dc\u5355\u6210\u529f");
        } else {
            this.publishService.hideMenuRes(id);
            response.setErrorCode(200);
            response.setErrorMsg("\u53d6\u6d88\u914d\u7f6e\u83dc\u5355");
        }
        return response;
    }

    @GetMapping(value={"/vue/batch"})
    public SpeedCodeResponse<String> vueBatch(@RequestParam(required=false) String appId) {
        return this.publishService.vueBatch("8205cb2057df723249476632b4b388e1");
    }
}

