/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.filepreview.start.controller;

import com.jxdinfo.filepreview.start.service.WkPreviewService;
import com.jxdinfo.filepreview.start.util.ResponseFileUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.ofdrw.converter.ConvertHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/wkpreview"})
@ConditionalOnWebApplication
public class WkPreviewController {
    @Resource
    private RestTemplate downloadProxyTemplate;
    @Resource
    private WkPreviewService wkPreviewService;
    @Value(value="${hussar-formdesign.workspace:}")
    private String outputPath;
    private static final Logger LOGGER = LoggerFactory.getLogger(WkPreviewController.class);

    @GetMapping(value={"/proxy"})
    public void getPostList(@RequestParam String url, HttpServletResponse response, @RequestParam(required=false) String mark) {
        this.wkPreviewService.getPostList(url, response, mark);
    }

    @GetMapping(value={"/deleteCache"})
    public void deleteCache() {
        ResponseFileUtil.deleteCache();
    }

    @PostMapping(value={"/ofd"})
    public void pdfConvert(MultipartHttpServletRequest multipartRequest, HttpServletResponse response) {
        MultipartFile multipartFile = null;
        Iterator iterator = multipartRequest.getFileMap().values().iterator();
        while (iterator.hasNext()) {
            MultipartFile file;
            multipartFile = file = (MultipartFile)iterator.next();
        }
        try {
            InputStream inputStream = multipartFile.getInputStream();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ConvertHelper.toPdf((InputStream)inputStream, (OutputStream)outputStream);
            byte[] pdfContent = outputStream.toByteArray();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_PDF);
            headers.setContentLength((long)pdfContent.length);
            response.setHeader("Content-Disposition", "attachment;fileName=" + this.getPdfFilename(multipartFile.getOriginalFilename()));
            response.setHeader("Content-Type", "application/pdf");
            StreamUtils.copy((byte[])outputStream.toByteArray(), (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to convert OFD to PDF", e);
        }
    }

    private String getPdfFilename(String originalFilename) {
        String baseName = FilenameUtils.getBaseName((String)originalFilename);
        String extension = ".pdf";
        return baseName + extension;
    }
}

